;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6271_CMP.Prj
;* File Name		  : M8P6271_CMP.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/14
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.8V 
;说明：本范例比较结果通过IOA2输出的高低判断
;比较器正相信号为CP1(IOA3)，反相信号为VREF_LCD选择2V
;IOA2 = 1  正相输入电压大于反相
;IOA2 = 0  正相输入电压小于反相
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================	
#INCLUDE	 	zc.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
;// userdata 	udata		H'00'
;// R_Flag		res			1
;// #define	b_Flag_Bit		R_Flag,0

;//===============================================================================
;//******************************* C O D E ***************************************
;//===============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//*********************************主函数****************************************
;//===============================================================================
;//-------------------------------程序初始化--------------------------------------
MainProgram:
		CALL   		System_Init          		;//系统初始化
        CALL		Clr_RAM_00H_7FH       		;//清零RAM	
		CALL		CMP_Init		      		;//CMP初始化
;//-------------------------------主函数循环--------------------------------------
MainLoop:
		CLRWDT	
		JBTS1		CMPC0,6
		GOTO		Set_IO_L
		BSET		IOA,2
		GOTO		MainLoop	
Set_IO_L:		
		BCLR		IOA,2
		GOTO	 	MainLoop	

;//===============================================================================
;//******************************中断处理程序*************************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================				
Interrupt:
		PUSH								;//压栈,保存A,STATUS
;//中断处理程序
		NOP
Interrupt_End:
		POP									;//出栈，恢复A,STATUS
		RETIE	

;//===============================================================================
;//*********************************CMP初始化*************************************
;//CMP设置：比较器正相为CP1(IOA3)输入，比较器反相为VREF_LCD = 2v
;//===============================================================================	
CMP_Init:
;//2、端口设置	
		BCLR		OEA,3								
;//3、比较器控制寄存器设置
		MOVIA		0x19									
		MOVAR		CMPC0
		MOVIA		0x0F								
		MOVAR		CMPC1
		MOVIA		0x00    							
		MOVAR		CMPC2
;//4.使能比较器
		BSET		CMPC0,7								
		RETURN 	

;//===============================================================================
;//******************************延时处理程序*************************************
;//===============================================================================
Delay:
		MOVIA		255
		DJZA		
		GOTO		$-1
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================	
System_Init:
;//-----------------------------------------------------------------------           
;//Init 系统时钟
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
;//----------------------------------------------------
;//端口模式设置	
		MOVIA		0x00		;//Bit0~6: 0:作为数字IO口 1:作为模拟端口
		MOVAR		ANSA		;//Bit7: 0=IOA3下拉关闭 1:IOA3下拉使能
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR		OPTION,GIE 	;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//*****************************RAM清零(0000H~007FH)******************************
;//RAM清零：RAM区0000H~007FH全部清零；
;//===============================================================================	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN
		END

;*********************************END OF FILE********************************** 