;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6272_ADC.Prj
;* File Name		  : ADC_Work.INC
;* Author			  : MASSES CHIP
;* Version            : V1.00
;* Date               : 2025/11/27
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例AD采集通道为AIN3(IOA3),时钟源选择为Fcpu/8，内部参考2V
;采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均,结果存放在R_ADC_DATA_SUM_H、
;R_ADC_DATA_SUM_L中，作为一次AD值
;//******************************************************************************
;//===============================================================================
;//*********************************ADC转换***************************************
;//一次AD值的转换
;//===============================================================================
ADCSampling12Bit:
		BSET		ADCON0,6
		JBTS0		ADCON0,6
		GOTO		$-1
		RETURN

;//===============================================================================
;//*********************************ADC处理程序***********************************
;//对采集的AD数据去除最大值和最小值后对剩下数据求平均
;//===============================================================================	
ADC_Work:
;//寄存器初始化赋值	
		MOVIA		10
		MOVAR		R_Count				
		;//把最大值初始化成最小值0x0000
		CLRR		R_ADC_MAX_DATAH
		CLRR		R_ADC_MAX_DATAL
		;//把最小值初始化成最大值0xFFFF
		MOVIA		0xFF
		MOVAR		R_ADC_MIN_DATAH 
		MOVAR		R_ADC_MIN_DATAL 
		;//求和寄存器清零
		CLRR		R_ADC_DATA_SUM_L 
		CLRR		R_ADC_DATA_SUM_H 
ADC_DATA_Collect_Lp:				
		CALL		ADCSampling12Bit
;//累加ADC测量数据
		MOVR		ADL,A								
		ADDAR		R_ADC_DATA_SUM_L,R		;//ADC低位累加
		MOVR		ADH,A
		ADCAR		R_ADC_DATA_SUM_H,R		;//ADC高位累加
;//判断最大值和最小值
		CALL		DATA_CMP	
		DJZR        R_Count,R
		GOTO        ADC_DATA_Collect_Lp    	;//循环测量10次数据		
;//减去最小值		
		MOVR        R_ADC_MIN_DATAL,A
		SUBRA		R_ADC_DATA_SUM_L,R
		MOVR        R_ADC_MIN_DATAH,A
		SBCRA 		R_ADC_DATA_SUM_H,R
;//减去最大值
		MOVR        R_ADC_MAX_DATAL,A
		SUBRA		R_ADC_DATA_SUM_L,R
		MOVR        R_ADC_MAX_DATAH,A
		SBCRA 		R_ADC_DATA_SUM_H,R
;//剩下8组数据平均	
		MOVIA       0x03
		MOVAR       R_Count
Average_loop:		
		BCLR		STATUS,C	
		RRR			R_ADC_DATA_SUM_H,R
		RRR         R_ADC_DATA_SUM_L,R
		DJZR		R_Count,R
		GOTO		Average_loop
;//测量ADC通道的最后结果放在ADC_DATA_SUM_H,ADC_DATA_SUM_L
		RETURN

;//===============================================================================
;//*********************************ADC最值寻找***********************************
;//找到数据的最大值和最小值
;//=============================================================================== 
DATA_CMP:
;//-----------------------------------------------------------------------------
;//最大值比较
MAX_DATA_CMP:
		MOVR		ADH,A
		JGAR        R_ADC_MAX_DATAH			;//ADC高位与最大值高位相比较
		GOTO        MIN_DATA_CMP
		JBTS1       STATUS,Z
		GOTO        MAX_DATA_Change
		MOVR		ADL,A					;//高位比较结果为0时比较低位
		JGAR        R_ADC_MAX_DATAL
		GOTO        MIN_DATA_CMP
;//把最大值更新为当前值
MAX_DATA_Change:   
		MOVR		ADH,A				
		MOVAR		R_ADC_MAX_DATAH 		;//将AD高位赋值到最大值高位
		MOVR		ADL,A
		MOVAR		R_ADC_MAX_DATAL 		;//将AD低位赋值到最大值低位
;//-----------------------------------------------------------------------------
;//最小值比较
MIN_DATA_CMP:
        MOVR		ADH,A
		JGAR        R_ADC_MIN_DATAH			;//ADC高位与最小值高位相比较
		GOTO        MIN_DATA_Change
		JBTS1       STATUS,Z
		GOTO        DATA_CMP_End
		MOVR		ADL,A					;//高位比较结果为0时比较低位
		JLAR        R_ADC_MIN_DATAL
		GOTO        DATA_CMP_End
;//把最小值更新为当前值
MIN_DATA_Change: 
		MOVR		ADH,A				
		MOVAR		R_ADC_MIN_DATAH 		;//将AD高位赋值到最小值高位
		MOVR		ADL,A
		MOVAR		R_ADC_MIN_DATAL 		;//将AD低位赋值到最小值低位
DATA_CMP_End:
		RETURN

;//*********************************END OF FILE******************************