/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P6272_ADC.Prj
* File Name          : ADC_WORK.C
* Author             : MASSES CHIP
* Version            : V1.00
* Date               : 2025/11/27
* Web    			 : www.masses-chip.com
* FAE                : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例AD采集通道为AIN3(IOA3),时钟源选择为Fcpu/8，内部参考2V
*采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均,结果存放在R_ADC_DATA_Sum中
*作为一次AD值
********************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
#include"zc.h"
#include"MASSESCHIP_DEFINE.H"

//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
volatile unsigned	int	 R_ADC_Temp;
volatile unsigned  	int	 R_ADC_MAX_DATA;
volatile unsigned  	int	 R_ADC_MIN_DATA;
volatile unsigned  	int	 R_ADC_DATA_Sum;

//===============================================================================
//***********************************ADC转换*************************************
//一次AD值的转换
//===============================================================================
void ADCSampling12Bit(void)
{
	ADS = 1;
	while(ADS == 1);	
}

//===============================================================================
//*********************************ADC处理程序***********************************
//对采集的AD数据去除最大值和最小值后对剩下数据求平均
//===============================================================================
void  ADC_Work(void)
{  	
	u8 R_ADC_COUNT;
	R_ADC_MIN_DATA = 0xFFFF;				 			//最小值赋值
	R_ADC_MAX_DATA = 0x0000;				 			//最大值赋值
	R_ADC_DATA_Sum = 0x0000;
	for(R_ADC_COUNT = 0;R_ADC_COUNT < 10;R_ADC_COUNT ++)
	{   
		ADCSampling12Bit();
		R_ADC_Temp = ADH; 								//取第3次的数据 
		R_ADC_Temp = R_ADC_Temp << 8;	   	 			//将ADH向左移8位
		R_ADC_Temp = R_ADC_Temp + ADL;	    			//R_ADC_Temp=ADH+ADL		
		R_ADC_DATA_Sum = R_ADC_DATA_Sum + R_ADC_Temp; 	//累加ADC测量数据		
		if(R_ADC_Temp > R_ADC_MAX_DATA)	     			//判断最大值
		{
			R_ADC_MAX_DATA = R_ADC_Temp;		
		}		
		if(R_ADC_Temp < R_ADC_MIN_DATA)	     			//判断最小值	
		{
			R_ADC_MIN_DATA = R_ADC_Temp;
		}	
	}
	R_ADC_DATA_Sum = R_ADC_DATA_Sum - R_ADC_MAX_DATA - R_ADC_MIN_DATA;
	R_ADC_DATA_Sum = R_ADC_DATA_Sum >> 3;				//剩下8组数据平均	
	//测量ADC通道的最后结果放在R_ADC_DATA_Sum
	__NOP();
}

//===============================================================================
//*********************************ADC初始化*************************************
//ADC设置：选择通道为AIN3，数据格式为右对齐，
//时钟源选择为Fcpu/8，内部参考2V
//ADC最大运行时钟为1MHz
//===============================================================================
void ADC_Init(void)
{
//1、IO设置
	OEA3 = 0;
	ANSA3 = 1;
//2、ADC设置 
	ADCON0 = 0xA3;
	ADCON1 = 0x35;
	ADCON2 = 0x00;	
}

/*********************************END OF FILE************************************/ 