;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6272_CMP.Prj
;* File Name		  : MAIN.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.00
;* Date               : 2025/11/27
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:32M/8T,WDT-Enable-288ms,BOR 2.4V 
;说明：本范例比较结果通过IOA6输出的高低判断
;比较器正相信号为CP(IOB4)，反相信号为 LVDS 选择2.5V（注：VDD=5V时，LVDS=2.5V）
;IOA6 = 1  正相输入电压大于反相
;IOA6 = 0  正相输入电压小于反相
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================	
#INCLUDE	 	zc.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
;// userdata 	udata		H'00'
;// R_Flag		res			1
;// #define	b_Flag_Bit		R_Flag,0

;//===============================================================================
;//******************************* C O D E ***************************************
;//===============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//*********************************主函数****************************************
;//===============================================================================
;//-------------------------------程序初始化--------------------------------------
MainProgram:
		CALL   		System_Init          		;//系统初始化
        CALL		Clr_RAM_00H_AFH       		;//清零RAM	
		CALL		CMP_Init		      		;//CMP初始化
;//-------------------------------主函数循环--------------------------------------
MainLoop:
		CLRWDT	
		JBTS1		CMPCR0,6
		GOTO		Set_IO_L
		BSET		IOA,6
		GOTO		MainLoop	
Set_IO_L:		
		BCLR		IOA,6
		GOTO	 	MainLoop	

;//===============================================================================
;//******************************中断处理程序*************************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================				
Interrupt:
		PUSH								;//压栈,保存A,STATUS
;//中断处理程序
		NOP
Interrupt_End:
		POP									;//出栈，恢复A,STATUS
		RETIE	

;//===============================================================================
;//*********************************CMP初始化*************************************
;//CMP设置：比较器输出极性选择0,CMPOL = 0 比较器输出正相,比较器正相为外部输入CP，比较器反相为 LVDS = 2.5v
;// VCN>VCP,CMPO = 0;VCN<VCP,CMPO = 1;
;//注：VDD=5V时，LVDS=2.5V,3V供电时，需要重新计算LVDS
;//===============================================================================	
CMP_Init:
;//2、端口设置	
		BCLR		OEB,4								
;//3、比较器控制寄存器设置
		MOVIA		0x1C									
		MOVAR		CMPCR0
		MOVIA		0x07								
		MOVAR		CMPCR1
		MOVIA		0x00    							
		MOVAR		CMPCR2
;//4.使能比较器
		BSET		CMPCR0,7								
		RETURN 	
;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================	
SYSTEM_INIT:
;//-----------------------------------------------------------------------
;//SystemInit Clock
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA
		
		;//IOB
		MOVIA      	0x00    	;//Bit0~5: PUB0~PUB5  0:上拉关闭 1:上拉使能
								;//Bit6: PDA0		0:下拉关闭 1:下拉使能
								;//Bit7: PDA2		0:下拉关闭
        MOVAR      	PUB
        MOVIA      	0x3F    	;//Bit0~5: OEB0~OEB5  0:输入 1:输出 
								;//Bit6: IOALDS    0:正常驱动    1:小驱动
								;//Bit7: IOBLDS    0:正常驱动						
        MOVAR      	OEB
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOB		
		
;//----------------------------------------------------
;//端口模式设置	
		MOVIA		0x00		
		MOVAR		ANSA		;//Bit0~6: 0:作为数字IO口 1:作为模拟端口
								;//Bit7: 0:IOA3下拉关闭 1:IOA3下拉使能
		
		MOVAR		ANSB		;//Bit0~5: 0:作为数字IO口 1:作为模拟端口
								;//Bit6: SMTENA    0:VDD/2       1:SMT
								;//Bit7: SMTENB    0:VDD/2       1:SMT
;//----------------------------------------------------------------------
;//中断设置
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断
		RETURN
;//===============================================================================
;//***************************** RAM清零(00H~AFH) ********************************
;//RAM清零：RAM区0000H~00AFH全部清零
;//===============================================================================
Clr_RAM_00H_AFH:
		CLRR		FSR0		;//从00地址开始写入
Clr_RAM_00H_AFH_LOOP:
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		MOVIA       0xB0
		JCMPAR		FSR0
		GOTO		Clr_RAM_00H_AFH_LOOP
		RETURN
		END

;*********************************END OF FILE********************************** 