/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P6272_CMP.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.00
* Date               : 2025/11/27
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/8T,WDT-Enable-288ms,BOR 2.4V 
*说明：本范例比较结果通过IOA6输出的高低判断
*比较器正相信号为CP(IOB4)，反相信号为 LVDS 选择2.5V (注：VDD=5v时，LVDS=2.5V)
*IOA6 = 1  正相输入电压大于反相
*IOA6 = 0  正相输入电压小于反相
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.h"
//-------------------------------------------------------------------------------
//用户可以自行更改
void System_Init(void);
void Clr_RAM_00H_AFH(void);
void CMP_Init(void);

//===============================================================================
//******************************中断特殊函数保护*********************************
/* 如果主程序和中断都用到特殊函数时（例：有变量的乘除法、传参和数组等需要读取或
写入通用指针指向的字节操作），那么在进中断前需要对编译器的临时性寄存器保存。 */
//===============================================================================
#define			Save_Special_Function		1		//中断使用特殊函数时必须置“1”

//如果主程序和中断都用到数组、指针、查表时，需对所用寄存器保存
#define			Save_Fsr					1		//中断使用寻址时必须置“1”

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
#ifdef	Save_Special_Function
u8 R_Save_Stk00,R_Save_Stk01,R_Save_Stk02,R_Save_Stk03,R_Save_Stk04,R_Save_Stk05;
u8 R_Save_Stk06,R_Save_Stk07,R_Save_Stk08,R_Save_Stk09,R_Save_Stk10,R_Save_Stk11;
#endif
 
#ifdef	Save_Fsr
u8 R_Save_Fsr0;
u8 R_Save_Fsr1;
u8 R_Save_Hbuf;
#endif

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)						//程序主函数
{
	System_Init();					//系统初始化
	Clr_RAM_00H_AFH();				//清零RAM
	CMP_Init();						//CMP初始化
	while(1) 
	{
		__CLRWDT();           		//清除看门狗
		if(CMPO)
		{
			IOA6 = 1;
		}
		else
		{
			IOA6 = 0;
		}					
	}
}
//===============================================================================
//******************************中断服务子程序***********************************
//注：没有使能的中断不要判断中断标志位
//===============================================================================
void int_isr(void) __interrupt		//中断处理函数
{
	__PUSH();						//进栈（保存A, STATUS）

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//保存中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		STK00,0
	MOVAR		_R_Save_Stk00
	MOVR		STK01,0
	MOVAR		_R_Save_Stk01
	MOVR		STK02,0
	MOVAR		_R_Save_Stk02
	MOVR		STK03,0
	MOVAR		_R_Save_Stk03
	MOVR		STK04,0
	MOVAR		_R_Save_Stk04
	MOVR		STK05,0
	MOVAR		_R_Save_Stk05
	MOVR		STK06,0
	MOVAR		_R_Save_Stk06
	MOVR		STK07,0
	MOVAR		_R_Save_Stk07
	MOVR		STK08,0
	MOVAR		_R_Save_Stk08
	MOVR		STK09,0
	MOVAR		_R_Save_Stk09
	MOVR		STK10,0
	MOVAR		_R_Save_Stk10
	MOVR		STK11,0
	MOVAR		_R_Save_Stk11
__endasm;
#endif

#ifdef	Save_Fsr	 										//保存中断寻址指针FSR0、FSR1、HBUF
	R_Save_Fsr0 = FSR0;
	R_Save_Fsr1 = FSR1;
	R_Save_Hbuf = HBUF;
#endif
//---------------------------------------
	
//中断处理函数
	__NOP();

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//恢复中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		_R_Save_Stk00,0
	MOVAR		STK00
	MOVR		_R_Save_Stk01,0
	MOVAR		STK01
	MOVR		_R_Save_Stk02,0
	MOVAR		STK02
	MOVR		_R_Save_Stk03,0
	MOVAR		STK03
	MOVR		_R_Save_Stk04,0
	MOVAR		STK04
	MOVR		_R_Save_Stk05,0
	MOVAR		STK05
	MOVR		_R_Save_Stk06,0
	MOVAR		STK06
	MOVR		_R_Save_Stk07,0
	MOVAR		STK07
	MOVR		_R_Save_Stk08,0
	MOVAR		STK08
	MOVR		_R_Save_Stk09,0
	MOVAR		STK09
	MOVR		_R_Save_Stk10,0
	MOVAR		STK10
	MOVR		_R_Save_Stk11,0
	MOVAR		STK11
__endasm;
#endif

#ifdef	Save_Fsr	 										//恢复中断寻址指针FSR0、FSR1、HBUF
	FSR0 = R_Save_Fsr0;
	FSR1 = R_Save_Fsr1;
	HBUF = R_Save_Hbuf;	
#endif
//---------------------------------------

	__POP();						//出栈（恢复A, STATUS）
}

//===============================================================================
//*********************************CMP初始化*************************************
//CMP设置：比较器输出极性选择0,CMPOL = 0 比较器输出正相,比较器正相为外部输入CP，比较器反相为 LVDS = 2.5v
// VCN>VCP,CMPO = 0;VCN<VCP,CMPO = 1;
//注：该demo为5v供电，3v供电的情况下，需要计算LVDS
//===============================================================================
void CMP_Init(void)
{
//2、端口设置		
	OEB4 = 0;
//3、比较器控制寄存器设置
	CMPCR0 = 0x1C;				
	CMPCR1 = 0x07;
	CMPCR2 = 0x00;
//4.使能比较器
	CMPEN = 1;
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================
void System_Init(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	    
//Init IO             
	//IOA
	PUA = 0x00;					//0:上拉关闭 1:上拉使能
	OEA = 0xFF;					//0:输入 1:输出 
    IOA = 0x00;					//IO口数据
	
	//IOB
	PUB = 0x00;					//Bit0~5: PUB0~PUB5  0:上拉关闭 1:上拉使能
								//Bit6: PDA0		0:下拉关闭 1:下拉使能
								//Bit7: PDA2		0:下拉关闭 1:下拉使能
	OEB = 0x3F;					//Bit0~5: OEB0~OEB5  0:输入 1:输出 
								//Bit6: IOALDS    0:正常驱动    1:小驱动
								//Bit7: IOBLDS    0:正常驱动    1:小驱动
    IOB = 0x00;					//IO口数据
//----------------------------------------------------
//端口模式设置	
	ANSA = 0x00;				//Bit0~6: 0:作为数字IO口 1:作为模拟端口
								//Bit7: 0:IOA3下拉关闭 1:IOA3下拉使能							
	ANSB = 0x00;				//Bit0~5: 0:作为数字IO口 1:作为模拟端口
								//Bit6: SMTENA    0:VDD/2       1:SMT
								//Bit7: SMTENB    0:VDD/2       1:SMT
//----------------------------------------------------
//中断设置
	GIE = 0;					//1:总中断使能,0:屏蔽所有中断
}

//===============================================================================
//****************************** RAM清零(00H~AFH) *******************************
//RAM清零：RAM区0000H~00AFH全部清零
//===============================================================================
void Clr_RAM_00H_AFH()
{
    for(FSR0 = 0;FSR0 <= 0xAF;FSR0 ++)
	{
		INDF0 = 0x00;
	}
}

/*********************************END OF FILE************************************/