;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6272_IO_Interrupt.Prj
;* File Name		  : MAIN.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.00
;* Date               : 2025/11/27
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:32M/8T,WDT-Disable-288ms,BOR 2.4V 
;说明：本范例IOA3外部中断唤醒休眠后翻转IOA6口
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	 zc.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata 		udata			H'00'
R_Flag			res				1
#define	B_IO_Interrupt_Flag		R_Flag,0

;//===============================================================================
;//******************************* C O D E ***************************************
;//===============================================================================
		ORG			 0000H
		GOTO		 MainProgram
		ORG			 0008H
		GOTO		 Interrupt

;//===============================================================================
;//*********************************主函数****************************************
;//===============================================================================
MainProgram:
		CALL         System_Init           ;//系统初始化
        CALL		 Clr_RAM_00H_AFH       ;//清零RAM		
		CALL         IO_Interrupt_Init     ;//IO中断初始化	 
;//-------------------------------主函数循环--------------------------------------	
MainLoop:
		CLRWDT
		JBTS1		B_IO_Interrupt_Flag
		GOTO		MainLoop_1
		BCLR		B_IO_Interrupt_Flag
		JBTS1		IOA,3
		GOTO		Set_IO_H
		BCLR		IOA,6
		GOTO		MainLoop_1
Set_IO_H:		
		BSET		IOA,6		
MainLoop_1:
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		GOTO		MainLoop

;//===============================================================================
;//******************************中断处理程序*************************************
;//每触发一次中断，标志位置高
;//===============================================================================
Interrupt:
		PUSH                               ;//压栈,保存A,STATUS
;//中断处理程序
		JBTS1		INTF0,IOAIF
		GOTO		Interrupt_END
		BCLR		INTF0,IOAIF
		BSET		B_IO_Interrupt_Flag
Interrupt_END:		          
		POP                                ;//出栈,恢复A,STATUS
		RETIE			      		

;//===============================================================================
;//*********************************IO中断初始化**********************************
;//中断口为IOA3，设置为输入上拉
;//开启IO变化中断和总中断
;//===============================================================================	
IO_Interrupt_Init:
;//1、IO设置
		BCLR		OEA,3
		BSET		PUA,3
;//2、中断设置
		BSET		IOAICR,3
		BSET		INTCR0,4		
		BCLR		INTF0,4
		BSET		OPTION,GIE
		MOVIA		0x05
		MOVAR		OSCM
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================
SYSTEM_INIT:
;//-----------------------------------------------------------------------
;//SystemInit Clock
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA
		
		;//IOB
		MOVIA      	0x00    	;//Bit0~5: PUB0~PUB5  0:上拉关闭 1:上拉使能
								;//Bit6: PDA0		0:下拉关闭 1:下拉使能
								;//Bit7: PDA2		0:下拉关闭
        MOVAR      	PUB
        MOVIA      	0x3F    	;//Bit0~5: OEB0~OEB5  0:输入 1:输出 
								;//Bit6: IOALDS    0:正常驱动    1:小驱动
								;//Bit7: IOBLDS    0:正常驱动						
        MOVAR      	OEB
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOB		
		
;//----------------------------------------------------
;//端口模式设置	
		MOVIA		0x00		
		MOVAR		ANSA		;//Bit0~6: 0:作为数字IO口 1:作为模拟端口
								;//Bit7: 0:IOA3下拉关闭 1:IOA3下拉使能
		
		MOVAR		ANSB		;//Bit0~5: 0:作为数字IO口 1:作为模拟端口
								;//Bit6: SMTENA    0:VDD/2       1:SMT
								;//Bit7: SMTENB    0:VDD/2       1:SMT
;//----------------------------------------------------------------------
;//中断设置
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断
		RETURN

;//===============================================================================
;//***************************** RAM清零(00H~AFH) ********************************
;//RAM清零：RAM区0000H~00AFH全部清零
;//===============================================================================
Clr_RAM_00H_AFH:
		CLRR		FSR0		;//从00地址开始写入
Clr_RAM_00H_AFH_LOOP:
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		MOVIA       0xB0
		JCMPAR		FSR0
		GOTO		Clr_RAM_00H_AFH_LOOP
		RETURN
		END

;//*************************END OF FILE******************************************