;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6272_PWM0.Prj
;* File Name		  : MAIN.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.00
;* Date               : 2025/11/27
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:32M/8T,WDT-DisEnable-288ms,BOR 2.4V 
;说明：本范例以TC0为时基，产生1KHz占空比为50%的方波
;PWM0开启100ms，关闭100ms
;PWM0输出端口为IOB0
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================		
#INCLUDE	 	zc.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata			udata		H'00'
R_Delay_Count		res		1						;//延时计数R_Delay_Count
R_Delay_Count_1		res		1						;//延时计数R_Delay_Count_1
R_Delay_Count_2		res		1						;//延时计数R_Delay_Count_2

;//===============================================================================
;//******************************* C O D E ***************************************
;//===============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//*********************************主程序****************************************
;//===============================================================================
;//-------------------------------程序初始化--------------------------------------	
MainProgram:
		CALL		System_Init           	;//系统初始化
		CALL		Clr_RAM_00H_AFH       	;//清零RAM
		CALL		PWM0_Init		      	;//PWM0初始化
;//-------------------------------主函数循环--------------------------------------		
MainLoop:
		CLRWDT                           	;//清除看门狗
		BSET		T0CR1,6
		CALL		Delay_100ms
		BCLR		T0CR1,6
		CALL		Delay_100ms
		GOTO		MainLoop

;//===============================================================================
;//******************************中断处理程序*************************************
;//注:没有使能的中断不要判断中断标志位
;//===============================================================================				
Interrupt:
		PUSH								;//压栈,保存A,STATUS
;//中断处理程序
		NOP
Interrupt_End:
		POP									;//出栈，恢复A,STATUS
		RETIE					      		

;//===============================================================================
;//******************************延时处理程序*************************************
;//===============================================================================
;//延时100ms/32M/8T下
Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN

;//===============================================================================
;//**********************************PWM0初始化***********************************
;//PWM0输出口为IOB0
;//以TC0作为时基产生1KHz占空比为50%的方波
;//===============================================================================	
PWM0_Init:
;//1、IO端口设置
		MOVIA		0X10
		MOVAR		MPPWM0
		BSET		OEB,1
;//2、时钟源设置(以TC0为例,使其产生1KHz的波形)
		MOVIA		0x0F
		MOVAR		T0CR0
		CLRR		TC0CH
		MOVIA		249
		MOVAR		TC0CL
;//3、PWM0设置		
		MOVIA		0X00
		MOVAR		T0CR1
		MOVIA		125
		MOVAR		PWM0D
;//4、使能PWM0	
		BSET		T0CR0,7
		BSET		T0CR1,7
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================
SYSTEM_INIT:
;//-----------------------------------------------------------------------
;//SystemInit Clock
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA
		
		;//IOB
		MOVIA      	0x00    	;//Bit0~5: PUB0~PUB5  0:上拉关闭 1:上拉使能
								;//Bit6: PDA0		0:下拉关闭 1:下拉使能
								;//Bit7: PDA2		0:下拉关闭
        MOVAR      	PUB
        MOVIA      	0x3F    	;//Bit0~5: OEB0~OEB5  0:输入 1:输出 
								;//Bit6: IOALDS    0:正常驱动    1:小驱动
								;//Bit7: IOBLDS    0:正常驱动						
        MOVAR      	OEB
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOB		
		
;//----------------------------------------------------
;//端口模式设置	
		MOVIA		0x00		
		MOVAR		ANSA		;//Bit0~6: 0:作为数字IO口 1:作为模拟端口
								;//Bit7: 0:IOA3下拉关闭 1:IOA3下拉使能
		
		MOVAR		ANSB		;//Bit0~5: 0:作为数字IO口 1:作为模拟端口
								;//Bit6: SMTENA    0:VDD/2       1:SMT
								;//Bit7: SMTENB    0:VDD/2       1:SMT
;//----------------------------------------------------------------------
;//中断设置
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断
		RETURN

;//===============================================================================
;//***************************** RAM清零(00H~AFH) ********************************
;//RAM清零：RAM区0000H~00AFH全部清零
;//===============================================================================
Clr_RAM_00H_AFH:
		CLRR		FSR0		;//从00地址开始写入
Clr_RAM_00H_AFH_LOOP:
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		MOVIA       0xB0
		JCMPAR		FSR0
		GOTO		Clr_RAM_00H_AFH_LOOP
		RETURN

		END

;//*********************************END OF FILE***********************************     