;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P6272_TC1.Prj
;* File Name		  : MAIN.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.00
;* Date               : 2025/11/27
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:32M/8T,WDT-Enable-288ms,BOR 2.4V 
;说明：本范例以TC1为定时器，大概1ms翻转一次IOB0口
;16位计数器无自动重载功能，中断需要重新加载计数器初值，定时时间会有些许影响
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================	
#INCLUDE	 	 zc.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata	udata		H'00'
R_Flag		res			1
#define	b_TC1_Flag		R_Flag,0

;//===============================================================================
;//******************************** C O D E **************************************
;//===============================================================================
		ORG			 0000H
		GOTO		 MainProgram
		ORG			 0008H
		GOTO		 Interrupt

;//===============================================================================
;//*********************************主函数****************************************
;//===============================================================================
MainProgram:
		CALL         System_Init           ;//系统初始化
        CALL		 Clr_RAM_00H_AFH       ;//清零RAM		
		CALL         TC1_Init              ;//TC0初始化	 
;//-------------------------------主函数循环--------------------------------------		
MainLoop:
		CLRWDT                             ;//清除看门狗
		JBTS1		 b_TC1_Flag
		GOTO		 MainLoop
		BCLR		 b_TC1_Flag
		MOVIA		 0x01
		XORAR		 IOB,R
		GOTO		 MainLoop			

;//===============================================================================
;//******************************中断处理程序*************************************
;//定时中断，标志位置高
;//===============================================================================
Interrupt:
		PUSH                               ;//压栈,保存A,STATUS
;//中断处理程序
		JBTS1		INTF0,TC1IF
		GOTO		Interrupt_END
		BCLR		INTF0,TC1IF
		MOVIA		0x18
		MOVAR		TC1CL
		MOVIA		0xFC
		MOVAR		TC1CH					;//16位重新装载		
		BSET		b_TC1_Flag
Interrupt_END:		          
		POP                                ;//出栈,恢复A,STATUS
		RETIE			      		

;//===============================================================================
;//*********************************TC1初始化*************************************
;//TC1设置：16位模式、高频32M 32分频，定时为1ms
;//t =计数/（时钟/分频）     1ms = （999+1）/（32/32）
;//开启TC1溢出中断和总中断
;//===============================================================================	
TC1_Init:
;//1、TC1设置
		MOVIA		0x4D
		MOVAR		T1CR0
		MOVIA		0x18
		MOVAR		TC1CL
		MOVIA		0xFC
		MOVAR		TC1CH
		BSET		T1CR0,7
;//2、中断设置
		BCLR		INTF0,TC1IF
		BSET		INTCR0,TC1IE
		BSET		OPTION,GIE
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO为数字IO口输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================
SYSTEM_INIT:
;//-----------------------------------------------------------------------
;//SystemInit Clock
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA
		
		;//IOB
		MOVIA      	0x00    	;//Bit0~5: PUB0~PUB5  0:上拉关闭 1:上拉使能
								;//Bit6: PDA0		0:下拉关闭 1:下拉使能
								;//Bit7: PDA2		0:下拉关闭
        MOVAR      	PUB
        MOVIA      	0x3F    	;//Bit0~5: OEB0~OEB5  0:输入 1:输出 
								;//Bit6: IOALDS    0:正常驱动    1:小驱动
								;//Bit7: IOBLDS    0:正常驱动						
        MOVAR      	OEB
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOB		
		
;//----------------------------------------------------
;//端口模式设置	
		MOVIA		0x00		
		MOVAR		ANSA		;//Bit0~6: 0:作为数字IO口 1:作为模拟端口
								;//Bit7: 0:IOA3下拉关闭 1:IOA3下拉使能
		
		MOVAR		ANSB		;//Bit0~5: 0:作为数字IO口 1:作为模拟端口
								;//Bit6: SMTENA    0:VDD/2       1:SMT
								;//Bit7: SMTENB    0:VDD/2       1:SMT
;//----------------------------------------------------------------------
;//中断设置
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断
		RETURN

;//===============================================================================
;//***************************** RAM清零(00H~AFH) ********************************
;//RAM清零：RAM区0000H~00AFH全部清零
;//===============================================================================
Clr_RAM_00H_AFH:
		CLRR		FSR0		;//从00地址开始写入
Clr_RAM_00H_AFH_LOOP:
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		MOVIA       0xB0
		JCMPAR		FSR0
		GOTO		Clr_RAM_00H_AFH_LOOP
		RETURN
		END

;//*************************END OF FILE******************************************