; *******************(C) COPYRIGHT 2025 Masses-Chip ******************************
; *Project Name        : M8P6272_WS2812.Prj
; * File Name          : WS2812_Work.INC
; * Author             : MASSES CHIP
; * Version            : V1.00
; * Date               : 2025/11/27
; * Web    			   : www.masses-chip.com
; * FAE                : Luo
; *  				   : QQ：411680975
; ********************************************************************************
; *
; *Option:32M/8T,WDT-Enable-288ms,BOR 2.4V 
; *注意：本范例仅供参考，实际应用需评估硬件兼容性
; *说明：本范例点亮10个RGB灯珠,每隔1s切换灯珠的三种颜色,波形从PWM11口（IOB3）输出
; ******************************************************************************
;//===============================================================================
;//*******************************头文件和调用申明********************************
;//===============================================================================
;//用户不可更改
;//===============================================================================
;//*********************************LED处理程序***********************************
;//===============================================================================
WS2812_LED:

		JBTS1	b_1S_Flag
		GOTO	WS2812_LED_END
		BCLR	b_1S_Flag				
Color_Status_Handle:		
		MOVIA	0X00
		JNCMPAR	Color_Status
		GOTO	LED_G_Color					;//Color_Status = 0
		MOVIA	0X01
		JNCMPAR	Color_Status	
		GOTO	LED_R_Color					;//Color_Status = 1
		MOVIA	0X02
		JNCMPAR	Color_Status	
		GOTO	LED_B_Color					;//Color_Status = 2
;-----------------------------显示蓝色		
LED_G_Color:
		MOVIA   0x00
		MOVAR	Led_Count
LED_G_Color_LOOP:		
		JBTS0	T1CR1,7					
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0XFF
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		INCR	Led_Count,1
		MOVIA	9
		JLAR	Led_Count
		GOTO	LED_G_Color_LOOP	
		GOTO    WS2812_LEDTr_END				;//Led_Count > 9
;-----------------------------显示绿色
LED_B_Color:
		MOVIA   0x00
		MOVAR	Led_Count
LED_B_Color_LOOP:		
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0XFF
		MOVAR	PWM12D
		INCR	Led_Count,1
		MOVIA	9
		JLAR	Led_Count					;//Led_Count > 9
		GOTO	LED_B_Color_LOOP	
		GOTO    WS2812_LEDTr_END
;-----------------------------显示红色		
LED_R_Color:
		MOVIA   0x00
		MOVAR	Led_Count
LED_R_Color_LOOP:		
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0XFF
		MOVAR	PWM12D
		JBTS0	T1CR1,7
		GOTO	$-1							;//LEDBUSY:1=正在发送数据,不允许写入
		MOVIA	0X00
		MOVAR	PWM12D
		INCR	Led_Count,1
		MOVIA	9
		JLAR	Led_Count					;//Led_Count > 9
		GOTO	LED_R_Color_LOOP			
		GOTO    WS2812_LEDTr_END
		
WS2812_LEDTr_END:
		INCR	Color_Status,1
		MOVIA	0X03
		JCMPAR	Color_Status				
		GOTO    WS2812_LED_END
		CLRR	Color_Status

WS2812_LED_END:		
		RETURN

;//===============================================================================
;//**********************************TC0初始化***********************************
;//TC0设置：8位模式、高频32M 128分频，定时为1ms
;//t =计数/（时钟/分频）     1ms = （249+1）/（32/128）
;//中开启TC0溢出中断和总中断
;//===============================================================================
TC0_INIT:
;//1、TC0设置
		MOVIA   0x0F
		MOVAR   T0CR0
		MOVIA   249
		MOVAR   TC0CL
		CLRR    TC0CH
		BSET    T0CR0,7
;//2、中断设置	
		BSET	INTF0,0
		BSET	INTCR0,0
		BSET	OPTION,GIE
		RETURN
;//===============================================================================
;//*********************************TC0初始化*************************************
;//使能LED功能,单字节发送
;//码周期1.25us,0码高电平设置为312.5ns,1码高电平设置为750ns
;//===============================================================================
TC1_INIT:
		MOVIA	0X02
		MOVAR	MPPWM1		;PWM10/11/12/13映射：IOA2、IOB3、IOB4、IOB5
		MOVIA	0XA8
		MOVAR	T1CR0
		MOVIA	0X07
		MOVAR	T1CR1
		CLRR	TC0CH
		MOVIA	39
		MOVAR	TC1CL
		MOVIA	13
		MOVAR	PWM10D
		MOVIA	26
		MOVAR	PWM11D	
		MOVIA	0X02
		MOVAR	PWM1CR
		RETURN

;/*********************************END OF FILE************************************/
		