/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P6272_WS2812.Prj
* File Name          : WS2812_Work.C
* Author             : MASSES CHIP
* Version            : V1.00
* Date               : 2025/11/27
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:16M/4T,WDT-Disable-288ms,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例点亮10个RGB灯珠,每隔1s切换灯珠的三种颜色,//波形从PWM11口输出
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"

//===============================================================================
//*******************************寄存器定义***************************************
//===============================================================================
unsigned char	Color_Status;
unsigned int    R_TC0_COUNT;
//===============================================================================
//*********************************WS2812处理程序********************************
//===============================================================================
void WS2812_LED (void)
{
	unsigned char Led_Count;

	if(R_TC0_COUNT >= 1000)					//1s计时		
	{
		for(Led_Count = 0;Led_Count < 10;Led_Count ++)
		{
			if(Color_Status == 0)
			{
				while(LEDBUSY == 1);			//正在发送数据,不允许写入
				PWM12D = 0XFF; 
				while(LEDBUSY == 1);			
				PWM12D = 0X00; 
				while(LEDBUSY == 1);			
				PWM12D = 0X00;	
			}
			else if(Color_Status == 1)
			{
				while(LEDBUSY == 1);			
				PWM12D = 0X00; 
				while(LEDBUSY == 1);			
				PWM12D = 0XFF; 
				while(LEDBUSY == 1);				
				PWM12D = 0X00;	
			}
			else if(Color_Status == 2)
			{
				while(LEDBUSY == 1);			
				PWM12D = 0X00; 
				while(LEDBUSY == 1);			
				PWM12D = 0X00; 
				while(LEDBUSY == 1);				
				PWM12D = 0XFF;	
			}
		}
		Color_Status ++;
		if(Color_Status >= 3)
		{
			Color_Status = 0;
		}
		R_TC0_COUNT = 0;
	}
}

//===============================================================================
//**********************************TC0初始化***********************************
//TC0设置：8位模式、高频32M 128分频，定时为1ms
//t =计数/（时钟/分频）     1ms = （249+1）/（32/128）
//中开启TC0溢出中断和总中断
//===============================================================================
void TC0_INIT(void)
{
//1、TC0设置
	T0CR0 = 0x0F;
	TC0CL = 249;
	TC0CH = 0;
	TC0EN = 1;
//2、中断设置	
	TC0IF = 0;
	TC0IE = 1;
	GIE = 1;
}
//===============================================================================
//*********************************TC1初始化*************************************
//使能LED功能,单字节发送
//码周期1.25us,0码高电平设置为312.5ns,1码高电平设置为750ns
//===============================================================================
void TC1_INIT(void)
{
	MPPWM1 = 0X02;		//PWM10/11/12/13映射：IOA2、IOB3、IOB4、IOB5
    T1CR0 = 0xA8;
	T1CR1 = 0x07;
	TC1CL = 39;	
	PWM10D = 13;
	PWM11D = 26;
	PWM1CR = 0x02;//波形从PWM11口（IOB3）输出
}
//===============================================================================
//*********************************TC0中断处理**********************************
//===============================================================================
void TC0_Interrupt (void)
{
	if(TC0IF)			//1ms
	{
		TC0IF = 0;
		R_TC0_COUNT++;
	}
}
/*********************************END OF FILE************************************/