;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P632_I2C.prj
;* File Name		  : I2C_Slave_Work.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;说明：本范例为IIC从机接收模式，包括主机对从机的写操作和主机读取从机的数据
;时钟线SCL(IOB3)、数据线SDA(IOB4)
;设备地址为0xA0，主机读模式时第一个数据为数据写入的开始地址，从该位置开始写
;入数据；主机读模式时读取原先写入的数据
;//******************************************************************************

;//==============================================================================
;//*******************************I2C从机工作************************************
;//==============================================================================
;//	判断主机是读还是写
I2C_Slave_Work:
		JBTS0		I2CCON,6					;//判断主机读还是写
		GOTO		I2C_Master_Read
;//-------------------------------------------
;//主机写      
I2C_Master_Write:
		JBTS0		I2CCON,5					;//判断主机发送从机地址还是数据
		GOTO		I2C_Master_Write_Data
;//-------------------------------------------
;//主机发送从机地址
I2C_Master_Write_Address:
		BCLR		b_Data_Address_F
		MOVR		I2CBUF,A					;//接收到的从机地址，取出
		GOTO		Interrupt_End
;//-------------------------------------------
;//	主机发送数据
I2C_Master_Write_Data:
		JBTS0		b_Data_Address_F			;//判断是否有数据地址
		GOTO		I2C_yes_Data_Address
;//-------------------------------------------
;//没有数据地址，该次发送的是数据地址
I2C_no_Data_Address:
		BSET		b_Data_Address_F			;//设置数据地址标志
		MOVR		I2CBUF,A
		MOVAR		R_Data_Address
		GOTO		Interrupt_End  
;//-------------------------------------------
;//有数据地址，接收数据，读取I2C0DBUF，写入
I2C_yes_Data_Address:
		MOVR		R_Data_Address,A
		MOVAR		FSR0
		MOVR		I2CBUF,A
		MOVAR		INDF0
		INCR		R_Data_Address,R
		GOTO		Interrupt_End
;//-------------------------------------------
;//主机读
I2C_Master_Read:
		JBTS0       I2CCON,NACK
		GOTO        I2C_Master_NACK_yes
;//-------------------------------------------
;//没有接收到NACK，一个字节传输传输未完成
I2C_Master_NACK_no:
		MOVR		R_Data_Address,A
		MOVAR		FSR0
		MOVR		INDF0,A
		MOVAR		I2CBUF
		INCR 		R_Data_Address,R
		GOTO		Interrupt_End
;//-------------------------------------------
;//接收到NACK，一个字节传输完成
I2C_Master_NACK_yes:
		MOVIA		0x55
		MOVAR		I2CBUF
		GOTO		Interrupt_End

;//******************************END OF FILE************************************