/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M8P632_I2C_Slave.prj
* File Name          : I2C_Slave_Work.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为IIC从机接收模式，包括主机对从机的写操作和主机读取从机的数据
*时钟线SCL(IOB3)、数据线SDA(IOB4)
*设备地址为0xA0，主机读模式时第一个数据为数据写入的开始地址，从该位置开始写
*入数据；主机读模式时读取原先写入的数据
******************************************************************************/

//=============================================================================
//*******************************I2C从机工作**********************************
//=============================================================================
//申明头文件和调用，用户不可更改
#include "ZC.h"
#include "MassesChip_Define.h"

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
volatile unsigned char	R_Data_Address;
volatile ab8 R_I2C_Flag;									//定义位寄存器
#define	b_Data_Address_F		R_I2C_Flag.oneBit.b0		//主机地址发送标志

//===============================================================================
//********************************IIC从机处理************************************
//===============================================================================
void I2C_Slave_Work(void)
{
	if(R_W==1)								//主机读
	{
		if(NACK==1)
		{
			I2CBUF=0x55;
		}
		else if(NACK==0)
		{
			FSR0=R_Data_Address;
			I2CBUF=INDF0;
			R_Data_Address++;
		}
	}
	else if(R_W==0)							//主机写
	{
		if(D_A==1)
		{
			if(b_Data_Address_F==1)
			{
				FSR0=R_Data_Address;
				INDF0=I2CBUF;
				R_Data_Address++;
			}
			else if(b_Data_Address_F==0)
			{
				b_Data_Address_F=1;
				R_Data_Address=I2CBUF;
			}
		}
		else if(D_A==0)
		{
			b_Data_Address_F=0;
			__asm;
				MOVR		I2CBUF,A
			__endasm;
		}
	}
}

//******************************END OF FILE*************************************