;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P632_IOC0_Interrupt.prj
;* File Name		  : M8P632_IOC0_Interrupt.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Disable-288ms,RST-IO,BOR 2.4V 
;说明：本范例IOC0外部中断唤醒休眠，翻转IOB0
;//******************************************************************************
;//==============================================================================
;//***********************************头文件*************************************
;//用户不可更改
;//==============================================================================
#INCLUDE	 	ZC.INC

;//==============================================================================
;//******************************定义全局变量************************************
;//用户可以自行看需求定义变量
;//==============================================================================
userdata	udata	H'00'
R_Flag		res    1
#define	b_IOC0_F		R_Flag,0			;//IOC0中断标志

;//==============================================================================
;//*********************************C O D E**************************************
;//==============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//==============================================================================
;//********************************程序主函数************************************
;//==============================================================================			
;//--------------------------------程序初始化------------------------------------
MainProgram:
		CALL		SYSTEM_INIT				;//系统初始化
		CALL		Clr_RAM_00H_FFH			;//清零RAM
		CALL		IOC0_Interrupt_INIT		;//IOC0外部中断初始化
;//------------------------------主函数循环--------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		JBTS1		b_IOC0_F
		GOTO		Start_Sleep
		BCLR		b_IOC0_F
		JBTS1		IOB,0
		GOTO		IOB0_SET_1
IOB0_SET_0:
		BCLR		IOB,0
		GOTO		Start_Sleep
IOB0_SET_1:
		BSET		IOB,0
Start_Sleep:
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		GOTO		MainLoop

;//==============================================================================
;//******************************中断服务子程序**********************************
;//触发外部中断设置一次IOC0中断标志位
;//==============================================================================
;//中断进来
Interrupt:
		PUSH								;//压栈（保存A，STATUS）
		JBTS1		INTF1,IOCCHIF
		GOTO		Interrupt_END
		BCLR		INTF1,IOCCHIF
		BSET		b_IOC0_F
Interrupt_END:
;//中断结束
		POP									;//压栈（恢复A，STATUS）
	    RETIE

;//==============================================================================
;//****************************IOC0外部中断初始化********************************
;//IOC0端口设置：上拉，输入
;//开启IOC端口变化中断、使能IOC0端口电平变化中断、开启总中断
;//OSCM设置：休眠状态下关闭高/低频振荡器
;//==============================================================================	
IOC0_Interrupt_INIT:
;//1、端口设置
		BSET		PUC,0
		BCLR		OEC,0
;//2、中断设置
		BCLR		INTF1,IOCCHIF
		BSET		INTCR1,IOCCHIE
		BSET		IOCICR,0
		BSET       	OPTION,7
;//3、OSCM设置
		MOVIA		0x05
		MOVAR		OSCM
		RETURN

;//==============================================================================
;//**********************************系统初始化**********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//==============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO
        ;//IOA
        MOVIA      	0x00 
		MOVAR		ANSA		;//0:数字口	  1:模拟口 
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能  	 	
        MOVAR      	PDA			;//0:下拉关闭 1:下拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
		MOVIA		0x00
        MOVAR      	PUB
        MOVAR      	PDB
        MOVAR      	IOB
		MOVIA      	0xFF
        MOVAR      	OEB
		;//IOC
        MOVIA      	0x00
		MOVAR		ANSC
        MOVAR      	PUC
        MOVAR      	PDC
        MOVAR      	IOC
		MOVIA      	0xFF
        MOVAR      	OEC
;//------------------------------------------------------------------------      
;//Init Interrupt
		BCLR		OPTION,GIE		;//1:使能总中断  0:屏蔽总中断
		RETURN

;//==============================================================================
;//*******************************RAM清零(00H~FFH)*******************************
;//RAM清零：RAM区00H~FFH全部清零
;//==============================================================================				
Clr_RAM_00H_FFH:
		CLRR    	FSR0
ClrRam_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,R
		MOVIA		0xFF
		JCMPAR		FSR0
		GOTO		ClrRam_Loop
		MOVIA     	0x00
		MOVAR		INDF0
RAM_INIT_END:
		RETURN
		END

;//******************************END OF FILE************************************