;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P632_PMW0.prj
;* File Name		  : M8P632_PMW0.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Disable-288ms,RST-IO,BOR 2.4V 
;说明：本范例以PWM0P(IOB0)、PWM0N(IOB1）输出1KHz波形，输出控制每定时100ms调节一次
;IO口波形使能位控制输出的波形的开关，前、后死区时间32us
;//******************************************************************************
;//==============================================================================
;//***********************************头文件*************************************
;//用户不可更改
;//==============================================================================
#INCLUDE	 	ZC.INC

;//==============================================================================
;//******************************定义全局变量************************************
;//用户可以自行看需求定义变量
;//==============================================================================
userdata	udata	H'00'
R_Delay_Count			res		1						;//延时计数R_Delay_Count
R_Delay_Count_1			res		1						;//延时计数R_Delay_Count_1
R_Delay_Count_2			res		1						;//延时计数R_Delay_Count_2

;//==============================================================================
;//*********************************C O D E**************************************
;//==============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//==============================================================================
;//********************************程序主函数************************************
;//==============================================================================			
;//--------------------------------程序初始化------------------------------------
MainProgram:
		CALL		SYSTEM_INIT				;//系统初始化
		CALL		Clr_RAM_00H_FFH			;//清零RAM
		CALL		PWM0_INIT				;//PWM0初始化
;//------------------------------主函数循环--------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		BSET		PWM0CR,6
		BSET		PWM0CR,5
		CALL		Delay_100ms
		BCLR		PWM0CR,6
		BCLR		PWM0CR,5
		CALL		Delay_100ms
		GOTO		MainLoop

;//==============================================================================
;//******************************中断服务子程序**********************************
;//==============================================================================
;//中断进来
Interrupt:
		PUSH								;//压栈（保存A，STATUS）
		NOP
Interrupt_END:
;//中断结束
		POP									;//压栈（恢复A，STATUS）
	    RETIE

;//==============================================================================
;//*********************************PWM0初始化***********************************
;//TC0设置：递增模式，16M，高频系统时钟，1:64分频	t1 = 计数/（时钟/分频）= 1ms
;//PWM0设置：时基选择TC0，PWM0x波形输出端口用做IO口，占空比50%	频率 = 1/t1 =1KHz
;//死区设置：前、后死区时间为 32us
;//==============================================================================	
PWM0_INIT:
;//1、TC0设置
		MOVIA      	0x0E
		MOVAR	    T0CR
		CLRR		TC0CL
		CLRR	   	TC0CH
		MOVIA      	249
		MOVAR	   	TC0PRL
		MOVIA		0
		MOVAR		TC0PRH
		BSET       	T0CR,7
;//2、PWM0设置
		MOVIA		0x1C
		MOVAR		PWM0CR
		MOVIA		0x00
		MOVAR		PWMS
		MOVIA		(249+1)/2
		MOVAR		PWM0DL
		MOVIA		0
		MOVAR		PWM0DH
		MOVIA		0x77
		MOVAR		PWMDEADT
		BSET		PWM0CR,7
		RETURN

;//延时100ms/4T下
Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN

;//==============================================================================
;//**********************************系统初始化**********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//==============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO	
		;//IOA
        MOVIA      	0x00 
		MOVAR		ANSA		;//0:数字口	  1:模拟口 
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能  	 	
        MOVAR      	PDA			;//0:下拉关闭 1:下拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
		MOVIA		0x00
        MOVAR      	PUB
        MOVAR      	PDB
        MOVAR      	IOB
		MOVIA      	0xFF
        MOVAR      	OEB
		;//IOC
        MOVIA      	0x00
		MOVAR		ANSC
        MOVAR      	PUC
        MOVAR      	PDC
        MOVAR      	IOC
		MOVIA      	0xFF
        MOVAR      	OEC
;//------------------------------------------------------------------------      
;//Init Interrupt
		BCLR		OPTION,GIE		;//1:使能总中断  0:屏蔽总中断
		RETURN

;//==============================================================================
;//*******************************RAM清零(00H~FFH)*******************************
;//RAM清零：RAM区00H~FFH全部清零
;//==============================================================================				
Clr_RAM_00H_FFH:
		CLRR    	FSR0
ClrRam_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,R
		MOVIA		0xFF
		JCMPAR		FSR0
		GOTO		ClrRam_Loop
		MOVIA     	0x00
		MOVAR		INDF0
RAM_INIT_END:
		RETURN
		END

;//******************************END OF FILE************************************