;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P632_USART.prj
;* File Name		  : M8P632_USART.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;说明：本USART范例每100ms发送一次数据0x55；TX(IOB6)、RX(IOB7)；将接收到的数据格式
;正确的存放在R_RX_Data_Right，格式错误的存放在R_RX_Data_Error
;//******************************************************************************
;//==============================================================================
;//***********************************头文件*************************************
;//用户不可更改
;//==============================================================================
#INCLUDE	 	ZC.INC

;//==============================================================================
;//******************************定义全局变量************************************
;//用户可以自行看需求定义变量
;//==============================================================================
userdata	udata	H'00'
R_Delay_Count		res		1		;//延时计数R_Delay_Count
R_Delay_Count_1		res		1		;//延时计数R_Delay_Count_1
R_Delay_Count_2		res		1		;//延时计数R_Delay_Count_2
R_RX_Data_Right		res		1		;//存放接收到格式正确的数据
R_RX_Data_Error		res		1		;//存放接收到格式错误的数据

;//==============================================================================
;//*********************************C O D E**************************************
;//==============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//==============================================================================
;//********************************程序主函数************************************
;//==============================================================================			
;//--------------------------------程序初始化------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_FFH			;//清零RAM
		CALL       	USART_INIT				;//USART初始化
;//-------------------------------主函数循环-------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		CAll		Delay_100ms
		CALL		USART_Send_Data
		GOTO		MainLoop

;//--------------------------------------------------------------------
;/发送数据
USART_Send_Data:
		MOVIA		0x55
		MOVAR		TXREG
		JBTS1		TXCR,6
		GOTO		$-1
		RETURN
		
;//==============================================================================
;//******************************中断服务子程序**********************************
;//接收数据，检测数据格式是否出错，正确放入R_RX_Data_Right，错误放入R_RX_Data_Error
;//注：中断接收标志由硬件清零
;//==============================================================================
Interrupt:
		PUSH								;//压栈（保存A，STATUS）
		JBTS0		INTF0,RXIF
		GOTO		USART_Recive_Data
Interrupt_END:
;//中断结束
		POP									;//压栈（恢复A，STATUS）
	    RETIE
;//--------------------------------------------------------------------
;/接收数据
USART_Recive_Data:
		JBTS0		RXCR,1
		GOTO		Save_Data_Error
Save_Data_Right:
		MOVR		RXREG,0
		MOVAR		R_RX_Data_Right
		GOTO		Interrupt_End
Save_Data_Error:
		MOVR		RXREG,0
		MOVAR		R_RX_Data_Error
		GOTO		Interrupt_End

;//==============================================================================
;//*********************************USART初始化**********************************
;//端口设置：RX(IOB7)接收端口设为输入，上拉,TX(IOB6)发送端口设为输出
;//波特率设置：目标波特率=Fosc/（（BRGD+1）×n）=38400
;//开启USART接收中断和总中断，关闭发送中断
;//==============================================================================	
USART_INIT:
;//1、端口设置
		BSET		OEB,6			;//TX
		BCLR		OEB,7			;//RX
		BSET		PUB,7	
;//2、USART设置
		MOVIA      	0x80
		MOVAR		TXCR
		MOVIA		0x80
		MOVAR		RXCR
;//3、波特率设置
		MOVIA		0x00
		MOVAR		BRGDH
		MOVIA		0x67
		MOVAR		BRGDL			;//波特率38400
;//4、中断设置
		BCLR		INTF0,RXIF
		BCLR		INTF0,TXIF
		BCLR		INTCR0,TXIE
		BSET		INTCR0,RXIE
		BSET		OPTION,GIE
		RETURN

;//延时100ms/4T下
Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN

;//==============================================================================
;//**********************************系统初始化**********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//==============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO	
		;//IOA
        MOVIA      	0x00 
		MOVAR		ANSA		;//0:数字口	  1:模拟口 
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能  	 	
        MOVAR      	PDA			;//0:下拉关闭 1:下拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
		MOVIA		0x00
        MOVAR      	PUB
        MOVAR      	PDB
        MOVAR      	IOB
		MOVIA      	0xFF
        MOVAR      	OEB
		;//IOC
        MOVIA      	0x00
		MOVAR		ANSC
        MOVAR      	PUC
        MOVAR      	PDC
        MOVAR      	IOC
		MOVIA      	0xFF
        MOVAR      	OEC
;//------------------------------------------------------------------------      
;//Init Interrupt
		BCLR		OPTION,GIE		;//1:使能总中断  0:屏蔽总中断
		RETURN

;//==============================================================================
;//*******************************RAM清零(00H~FFH)*******************************
;//RAM清零：RAM区00H~0FFH全部清零
;//==============================================================================				
Clr_RAM_00H_FFH:
		CLRR    	FSR0
ClrRam_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,R
		MOVIA		0xFF
		JCMPAR		FSR0
		GOTO		ClrRam_Loop
		MOVIA     	0x00
		MOVAR		INDF0
RAM_INIT_END:
		RETURN
		END

;//******************************END OF FILE************************************