/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M8P632_USART.prj
* File Name          : M8P632_USART.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*说明：本USART范例每100ms发送一次数据0x55；TX(IOB6)、RX(IOB7)；将接收到的数据格式
*正确的存放在R_RX_Data_Right，格式错误的存放在R_RX_Data_Error
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "ZC.h"
#include "MASSESCHIP_DEFINE.H"

//-----------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);						//系统初始化
void Clr_RAM_00H_FFH(void);					//寄存器清零
void USART_INIT(void);						//USART初始化
void USART_Recive_Interrupt(void);			//USART接收中断处理函数
void USART_Send_Data(unsigned char R_Data);	//发送数据
void Delay_100ms(void);						//延时100ms

//===============================================================================
//******************************中断特殊函数保护*********************************
/* 如果主程序和中断都用到特殊函数时（例：有变量的乘除法、传参和数组等需要读取或
写入通用指针指向的字节操作），那么在进中断前需要对编译器的临时性寄存器保存。 */
//===============================================================================
#define			Save_Special_Function		1		//中断使用特殊函数时必须置“1”

//如果主程序和中断都用到数组、指针、查表时，需对所用寄存器保存
#define			Save_Fsr					1		//中断使用寻址时必须置“1”

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
#ifdef	Save_Special_Function
u8 R_Save_Stk00,R_Save_Stk01,R_Save_Stk02,R_Save_Stk03,R_Save_Stk04,R_Save_Stk05;
u8 R_Save_Stk06,R_Save_Stk07,R_Save_Stk08,R_Save_Stk09,R_Save_Stk10,R_Save_Stk11;
#endif
 
#ifdef	Save_Fsr
u8 R_Save_Fsr0;
u8 R_Save_Fsr1;
u8 R_Save_Hbuf;
#endif

volatile unsigned char R_RX_Data_Right;		//存放接收到格式正确的数据
volatile unsigned char R_RX_Data_Error;		//存放接收到格式错误的数据

//=============================================================================
//********************************程序主函数***********************************
//=============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();						//系统初始化
	Clr_RAM_00H_FFH();					//清零RAM
	USART_INIT();						//USART初始化
	while(1)
	{
		__CLRWDT();		     			//清除看门狗
		Delay_100ms();
		USART_Send_Data(0x55);
	}
}

//=============================================================================
//******************************串口发送数据************************************
//=============================================================================
void USART_Send_Data(unsigned char R_Data)
{
	TXREG = R_Data;
	while(TMCLR == 0);
}

//=============================================================================
//******************************中断服务子程序*********************************
//=============================================================================
void int_isr(void) __interrupt
{
	__PUSH();                    	//进栈（保存A，STATUS）

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//保存中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		STK00,0
	MOVAR		_R_Save_Stk00
	MOVR		STK01,0
	MOVAR		_R_Save_Stk01
	MOVR		STK02,0
	MOVAR		_R_Save_Stk02
	MOVR		STK03,0
	MOVAR		_R_Save_Stk03
	MOVR		STK04,0
	MOVAR		_R_Save_Stk04
	MOVR		STK05,0
	MOVAR		_R_Save_Stk05
	MOVR		STK06,0
	MOVAR		_R_Save_Stk06
	MOVR		STK07,0
	MOVAR		_R_Save_Stk07
	MOVR		STK08,0
	MOVAR		_R_Save_Stk08
	MOVR		STK09,0
	MOVAR		_R_Save_Stk09
	MOVR		STK10,0
	MOVAR		_R_Save_Stk10
	MOVR		STK11,0
	MOVAR		_R_Save_Stk11
__endasm;
#endif

#ifdef	Save_Fsr	 										//保存中断寻址指针FSR0、FSR1、HBUF
	R_Save_Fsr0 = FSR0;
	R_Save_Fsr1 = FSR1;
	R_Save_Hbuf = HBUF;
#endif
//---------------------------------------

//中断处理	
	USART_Recive_Interrupt();

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//恢复中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		_R_Save_Stk00,0
	MOVAR		STK00
	MOVR		_R_Save_Stk01,0
	MOVAR		STK01
	MOVR		_R_Save_Stk02,0
	MOVAR		STK02
	MOVR		_R_Save_Stk03,0
	MOVAR		STK03
	MOVR		_R_Save_Stk04,0
	MOVAR		STK04
	MOVR		_R_Save_Stk05,0
	MOVAR		STK05
	MOVR		_R_Save_Stk06,0
	MOVAR		STK06
	MOVR		_R_Save_Stk07,0
	MOVAR		STK07
	MOVR		_R_Save_Stk08,0
	MOVAR		STK08
	MOVR		_R_Save_Stk09,0
	MOVAR		STK09
	MOVR		_R_Save_Stk10,0
	MOVAR		STK10
	MOVR		_R_Save_Stk11,0
	MOVAR		STK11
__endasm;
#endif

#ifdef	Save_Fsr	 										//恢复中断寻址指针FSR0、FSR1、HBUF
	FSR0 = R_Save_Fsr0;
	FSR1 = R_Save_Fsr1;
	HBUF = R_Save_Hbuf;	
#endif
//---------------------------------------

	__POP();                    	//出栈（恢复A，STATUS）
}

//=============================================================================
//***************************USART接收中断处理函数*****************************
//接收数据，检测数据格式是否出错，正确放入R_RX_Data_Right，错误放入R_RX_Data_Error
//注：中断接收标志由硬件清零
//=============================================================================
void USART_Recive_Interrupt(void)
{
	if(RXIF == 1)
	{
		if(FRER == 0)
		{
			R_RX_Data_Right = RXREG;
		}
		else
		{
			R_RX_Data_Error = RXREG;
		}
	}
}

//=============================================================================
//*********************************USART初始化*********************************
//端口设置：RX(IOB7)接收端口设为输入，上拉,TX(IOB6)发送端口设为输出
//波特率设置：目标波特率=Fosc/（（BRGD+1）×n）=38400
//开启USART接收中断和总中断，关闭发送中断
//=============================================================================
void USART_INIT(void)
{
//1、端口设置
	OEB6 = 1;			;//TX
	OEB7 = 0;			;//RX
	PUB7 = 1;
//2、USART设置
	TXCR = 0x80;
	RXCR = 0x80;
//3、波特率设置
	BRGDH = 0x00;
	BRGDL = 0x67;
//4、中断设置
	RXIF = 0;
	TXIF = 0;
	TXIE = 0;
	RXIE = 1;
	GIE = 1;
}
//=============================================================================
//*********************************延时100ms***********************************
//4T下延时100ms
//=============================================================================	
void Delay_100ms(void)
{
	u8	R_Delay_Count,R_Delay_Count_1,R_Delay_Count_2;
	for(R_Delay_Count = 2;R_Delay_Count > 0;R_Delay_Count --)
	{
		for(R_Delay_Count_1 = 150;R_Delay_Count_1 > 0;R_Delay_Count_1 --)
		{
			for(R_Delay_Count_2 = 188;R_Delay_Count_2 > 0;R_Delay_Count_2 --);
		}
	}
}

//=============================================================================
//*********************************系统初始化**********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//=============================================================================	
void SYSTEM_INIT(void)
{
//----------------------------------------------------
//Init Clock
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	PUB = 0x00;
	PDB = 0x00;
	IOB = 0x00;
	OEB = 0xFF;
	//IOC
	ANSC = 0x00;
	PUC = 0x00;
	PDC = 0x00;
	IOC = 0x00;
	OEC = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIE = 0;					//1:使能总中断  0:屏蔽总中断
}

//=============================================================================
//********************************RAM清零(00H~FFH)*****************************
//RAM清零：RAM区00H~FFH全部清零
//=============================================================================
void Clr_RAM_00H_FFH(void)
{
	for(FSR0 = 0;FSR0 != 0xFF;FSR0 ++)
	{
		INDF0 = 0x00;
	}
	if(FSR0 = 0xFF)
	{
		INDF0 = 0x00;
	}
}

//*********************************END OF FILE**********************************