/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M8P634_ADC.prj
* File Name          : ADC_Work.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：ADC通道选择AIN0(IOA0)，数据格式ADRES={ADH[3:0]，ADL[7:0]}ADC时钟源选择Fcpu，
* ADC参考电压VDD，采集10次值除去最大最小，剩余的求平均值
******************************************************************************/

//==============================================================================
//*********************************ADC工作**************************************
//采集10次值除去最大最小，剩余的求平均值
//==============================================================================
//申明头文件和调用，用户不可更改
#include "ZC.h"
#include "MASSESCHIP_DEFINE.H"

//-----------------------------------------------------------------------------
//用户可以自行更改
void Start_ADC_Convert(void);
void Compare_Data(void);

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
volatile unsigned int R_Temp;
volatile unsigned int R_ADC_max;
volatile unsigned int R_ADC_min;
volatile unsigned int R_ADC_sum;

//===============================================================================
//********************************ADC处理程序************************************
//===============================================================================
void ADC_Work(void)
{
	unsigned char i;
	R_ADC_min = 0xFFFF;
	R_ADC_max = 0x0000;
	R_ADC_sum = 0x0000;
	for(i = 10;i > 0;i --)
	{
		Start_ADC_Convert();
		Compare_Data();
	}
	R_ADC_sum = R_ADC_sum - R_ADC_max - R_ADC_min;	//减去最大、小值
	R_ADC_sum = R_ADC_sum >> 3;						//剩余8组数据求平均
}
//===============================================================================
//********************************ADC转换程序************************************
//开启ADC转换，累加采集到的ADC值
//===============================================================================
void Start_ADC_Convert(void)
{
	ADS = 1;
	while(ADS == 1);
	R_Temp = ADH;
	R_Temp = R_Temp << 8;
	R_ADC_sum = R_ADC_sum + R_Temp + ADL;
}
//===============================================================================
//********************************ADC数据比较************************************
//数据比较，确定最大、小值
//===============================================================================
void Compare_Data(void)
{
	R_Temp = ADH;
	R_Temp = R_Temp << 8;
	R_Temp = R_Temp + ADL;
	if(R_Temp > R_ADC_max)			//最大值比较
	{
		R_ADC_max = R_Temp;
	}
	if(R_Temp < R_ADC_min)			//最小值比较
	{
		R_ADC_min = R_Temp;
	}
}

//******************************END OF FILE*************************************