;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P634_I2C_Slave.prj
;* File Name		  : M8P634_I2C_Slave.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;说明：本范例为IIC从机接收模式，包括主机对从机的写操作和主机读取从机的数据
;时钟线SCL(IOB3)、数据线SDA(IOB4)
;设备地址为0xA0，主机读模式时第一个数据为数据写入的开始地址，从该位置开始写
;入数据；主机读模式时读取原先写入的数据
;//******************************************************************************
;//==============================================================================
;//***********************************头文件*************************************
;//用户不可更改
;//==============================================================================
INCLUDE	 	ZC.INC

;//==============================================================================
;//******************************定义全局变量************************************
;//用户可以自行看需求定义变量
;//==============================================================================
userdata	udata	H'00'
sFSR0				res		1		;//保护FSR0L
R_Data_Address		res		1		;//数据地址
R_I2C_Flag			res		1		;//I2C标志
#define		b_Data_Address_F		R_I2C_Flag,0		;//主机地址发送标志

;//==============================================================================
;//*********************************C O D E**************************************
;//==============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt
		
;//==============================================================================
;//********************************程序主函数************************************
;//==============================================================================			
;//--------------------------------程序初始化------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_FFH			;//清零RAM
		CALL       	I2C_Slave_INIT			;//I2C从机初始化
;//------------------------------主函数循环--------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		GOTO		MainLoop

;//==============================================================================
;//******************************中断服务子程序**********************************
;//中断进入前保存FSR0，中断会使用到，防止被修改
;//==============================================================================
;//中断进来
Interrupt:
		PUSH								;//压栈（保存A，STATUS）
		MOVR 		FSR0,A
		MOVAR 		sFSR0
		JBTS0		INTF0,I2CIF
		GOTO		I2C_Slave_Work
Interrupt_END:
;//中断结束
		MOVR		sFSR0,A
		MOVAR		FSR0
		POP									;//压栈（恢复A，STATUS）
	    RETIE

;//==============================================================================
;//*******************************I2C从机初始化**********************************
;//端口设置：SCL(IOB3)、SDA(IOB4)端口设为上拉输入
;//I2C 设置：使能串行通讯功能，从机地址位0xA0
;//中断设置：开启I2C中断与总中断
;//==============================================================================	
I2C_Slave_INIT:
;//1、端口设置
		BSET		PUB,3			;//SCL
		BCLR		OEB,3
		BSET		PUB,4			;//SDA
		BCLR		OEB,4
;//2、I2C设置
		MOVIA		0x80
		MOVAR		I2CCON
;//3、中断设置
		BCLR		INTF0,I2CIF
		BSET		INTCR0,I2CIE
		BSET		OPTION,GIE
		RETURN

;//==============================================================================
;//**********************************系统初始化**********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//==============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO
        ;//IOA
        MOVIA      	0x00 
		MOVAR		ANSA		;//0:数字口	  1:模拟口 
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能  	 	
        MOVAR      	PDA			;//0:下拉关闭 1:下拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
		MOVIA		0x00
        MOVAR      	PUB
        MOVAR      	PDB
        MOVAR      	IOB
		MOVIA      	0xFF
        MOVAR      	OEB
		;//IOC
        MOVIA      	0x00
		MOVAR		ANSC
        MOVAR      	PUC
        MOVAR      	PDC
        MOVAR      	IOC
		MOVIA      	0xFF
        MOVAR      	OEC
		;//IOD
        MOVIA      	0x00		;//注：IOA6、7端口上/下拉控制寄存器必须写0
        MOVAR      	PUD
        MOVAR      	PDD
        MOVAR      	IOD
		MOVIA      	0xFF
        MOVAR      	OED
;//------------------------------------------------------------------------
;//Init Interrupt
		BCLR		OPTION,GIE		;//1:使能总中断  0:屏蔽总中断
		RETURN

;//==============================================================================
;//******************************RAM清零(00H~FFH)********************************
;//RAM清零：RAM区00H~FFH全部清零
;//==============================================================================				
Clr_RAM_00H_FFH:
		CLRR    	FSR0
ClrRam_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,R
		MOVIA		0xFF
		JCMPAR		FSR0
		GOTO		ClrRam_Loop
		MOVIA     	0x00
		MOVAR		INDF0
RAM_INIT_END:
		RETURN

;//==============================================================================
;//********************************文件包含**************************************
;//==============================================================================
#include		I2C_Slave_Work.INC		;//I2C从机工作
		END

;//******************************END OF FILE*************************************