;//*****************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P634_OPA.prj
;* File Name		  : M8P634_OPA.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;说明：本范例以OPA经过校准之后，初始化运放反相输入GND，运放正相输入A0P(IOA4)，将两
;者差值10倍放大后通过A0X(IOB6)端口输出
;//******************************************************************************
;//==============================================================================
;//***********************************头文件*************************************
;//用户不可更改
;//==============================================================================
INCLUDE	 	ZC.INC

;//==============================================================================
;//******************************定义全局变量************************************
;//用户可以自行看需求定义变量
;//==============================================================================
userdata	udata	H'00'
R_Temp1		res    1
R_Temp2		res    1

;//==============================================================================
;//*********************************C O D E**************************************
;//==============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//==============================================================================
;//********************************程序主函数************************************
;//==============================================================================
;//--------------------------------程序初始化------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_FFH			;//清零RAM
		CALL       	OPA_INIT				;//OPA初始化
;//------------------------------主函数循环--------------------------------------
MainLoop:
		CLRWDT								;//清除看门狗
		GOTO		MainLoop

;//==============================================================================
;//******************************中断服务子程序**********************************
;//==============================================================================
;//中断进来
Interrupt:
		PUSH								;//压栈（保存A，STATUS）
		NOP
Interrupt_END:
;//中断结束
		POP									;//压栈（恢复A，STATUS）
	    RETIE
		
;//==============================================================================
;//*********************************OPA初始化************************************
;//OPA校准：使能运放，使能运放逻辑输出功能，失调校准模式，运放通路：0~2断开，3闭合
;			运放反相输入位选择[111](未定义)，运放正相输入位选择[011](VDD/2)
;			循环 校准参数位+1，判断 运放输出位 发生变化，校准结束。
;			如果 校准参数位 到[1111]时，运放输出位 仍为0，那校准值就是[1111]
;			保存校准参数位(OPAPOF)
;//端口设置：A0P、A0X设为输入
;//OPA 设置：运放反相输入GND，运放正相输入A0P，10倍放大
;//A0X端口测量放大的电压
;//==============================================================================
OPA_INIT:
;//--------------------------------------------------------------------
;//1、OPA校准
OPA_Calibrate:
		MOVIA      	0xBB
		MOVAR	    OPA0C0
		MOVIA		0xB0
		MOVAR	   	OPA0C1
		MOVIA      	0x08
		MOVAR	   	COPA0C
OPA_Calibrate_Loop:
		CALL		Delay
		JBTS0		OPA0C0,6
		GOTO		OPA_INIT_Loop
		INCR		OPA0C1,R
		MOVR		OPA0C1,A
		ANDIA		0x0F
		JCMPAI		0x0F
		GOTO		OPA_Calibrate_Loop
OPA_INIT_Loop:
		MOVIA 		b'11101111'
		MOVAR		OEA
		MOVIA 		b'10111111'
		MOVAR 		OEB
		MOVIA       0x09
		MOVAR	    OPA0C0
		MOVR		OPA0C1,A
		ANDIA		0x20
		MOVAR		OPA0C1
		MOVIA		0x0C
		MOVAR		COPA0C
		BSET		OPA0C0,7
		RETURN

;//延时
Delay:
		MOVIA		10
		MOVAR		R_Temp1
D1:
		MOVIA		200
		MOVAR		R_Temp2
D2:
		DJZR		R_Temp2,R
		GOTO		D2
		DJZR		R_Temp1,R
		GOTO		D1
		RETURN

;//==============================================================================
;//**********************************系统初始化**********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//==============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO
        ;//IOA
        MOVIA      	0x00 
		MOVAR		ANSA		;//0:数字口	  1:模拟口 
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能  	 	
        MOVAR      	PDA			;//0:下拉关闭 1:下拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
		MOVIA		0x00
        MOVAR      	PUB
        MOVAR      	PDB
        MOVAR      	IOB
		MOVIA      	0xFF
        MOVAR      	OEB
		;//IOC
        MOVIA      	0x00
		MOVAR		ANSC
        MOVAR      	PUC
        MOVAR      	PDC
        MOVAR      	IOC
		MOVIA      	0xFF
        MOVAR      	OEC
		;//IOD
        MOVIA      	0x00		;//注：IOA6、7端口上/下拉控制寄存器必须写0
        MOVAR      	PUD
        MOVAR      	PDD
        MOVAR      	IOD
		MOVIA      	0xFF
        MOVAR      	OED
;//------------------------------------------------------------------------
;//Init Interrupt
		BCLR		OPTION,GIE		;//1:使能总中断  0:屏蔽总中断
		RETURN

;//==============================================================================
;//*****************************RAM清零(00H~FFH)*****************************
;//RAM清零：RAM区00H~FFH全部清零
;//==============================================================================				
Clr_RAM_00H_FFH:
		CLRR    	FSR0
ClrRam_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,R
		MOVIA		0xFF
		JCMPAR		FSR0
		GOTO		ClrRam_Loop
		MOVIA     	0x00
		MOVAR		INDF0
RAM_INIT_END:
		RETURN
		END

;//******************************END OF FILE************************************