/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M8P634_TC2G.prj
* File Name          : M8P634_TC2G.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/07/11
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*说明：本范例是TC2以TC0(1ms定时)门控模式为上升沿到上升沿
*当TC0第二次上升沿TC2G产生中断(2ms)并翻转IOB0口
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "ZC.h"
#include "MASSESCHIP_DEFINE.H"
//-----------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void Clr_RAM_00H_FFH(void);				//寄存器清零
void TC2G_INIT(void);					//TC2G初始化

//===============================================================================
//******************************中断特殊函数保护*********************************
/* 如果主程序和中断都用到特殊函数时（例：有变量的乘除法、传参和数组等需要读取或
写入通用指针指向的字节操作），那么在进中断前需要对编译器的临时性寄存器保存。 */
//===============================================================================
#define			Save_Special_Function		1		//中断使用特殊函数时必须置“1”

//如果主程序和中断都用到数组、指针、查表时，需对所用寄存器保存
#define			Save_Fsr					1		//中断使用寻址时必须置“1”

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
#ifdef	Save_Special_Function
u8 R_Save_Stk00,R_Save_Stk01,R_Save_Stk02,R_Save_Stk03,R_Save_Stk04,R_Save_Stk05;
u8 R_Save_Stk06,R_Save_Stk07,R_Save_Stk08,R_Save_Stk09,R_Save_Stk10,R_Save_Stk11;
#endif
 
#ifdef	Save_Fsr
u8 R_Save_Fsr0;
u8 R_Save_Fsr1;
u8 R_Save_Hbuf;
#endif
//-----------------------------------------------------------------------------
volatile ab8 R_Flag;			//定义位寄存器
#define		b_TC2G_F		R_Flag.oneBit.b0		//TC2G中断标志

//=============================================================================
//********************************程序主函数***********************************
//=============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();						//系统初始化
	Clr_RAM_00H_FFH();					//清零RAM
	TC2G_INIT();						//TC2G初始化
	while(1) 
	{
		__CLRWDT();		     			//清除看门狗
		if(b_TC2G_F == 1)
		{
			b_TC2G_F = 0;
			if(IOB0 == 1)
			{
				IOB0 = 0;
			}
			else if(IOB == 0)
			{
				IOB0 = 1;
			}
		}
	}
}

//=============================================================================
//******************************中断服务子程序*********************************
//门控定时2ms，进一次中断，设置一次TC2G中断标志位，启动门控
//=============================================================================
void int_isr(void) __interrupt
{
	__PUSH();                    	//进栈（保存A，STATUS）

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//保存中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		STK00,0
	MOVAR		_R_Save_Stk00
	MOVR		STK01,0
	MOVAR		_R_Save_Stk01
	MOVR		STK02,0
	MOVAR		_R_Save_Stk02
	MOVR		STK03,0
	MOVAR		_R_Save_Stk03
	MOVR		STK04,0
	MOVAR		_R_Save_Stk04
	MOVR		STK05,0
	MOVAR		_R_Save_Stk05
	MOVR		STK06,0
	MOVAR		_R_Save_Stk06
	MOVR		STK07,0
	MOVAR		_R_Save_Stk07
	MOVR		STK08,0
	MOVAR		_R_Save_Stk08
	MOVR		STK09,0
	MOVAR		_R_Save_Stk09
	MOVR		STK10,0
	MOVAR		_R_Save_Stk10
	MOVR		STK11,0
	MOVAR		_R_Save_Stk11
__endasm;
#endif

#ifdef	Save_Fsr	 										//保存中断寻址指针FSR0、FSR1、HBUF
	R_Save_Fsr0 = FSR0;
	R_Save_Fsr1 = FSR1;
	R_Save_Hbuf = HBUF;
#endif
//---------------------------------------

//中断处理	
	if(TC2GIF == 1)
	{
		TC2GIF = 0;
		b_TC2G_F = 1;
		TC2GO = 1;
	}

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//恢复中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		_R_Save_Stk00,0
	MOVAR		STK00
	MOVR		_R_Save_Stk01,0
	MOVAR		STK01
	MOVR		_R_Save_Stk02,0
	MOVAR		STK02
	MOVR		_R_Save_Stk03,0
	MOVAR		STK03
	MOVR		_R_Save_Stk04,0
	MOVAR		STK04
	MOVR		_R_Save_Stk05,0
	MOVAR		STK05
	MOVR		_R_Save_Stk06,0
	MOVAR		STK06
	MOVR		_R_Save_Stk07,0
	MOVAR		STK07
	MOVR		_R_Save_Stk08,0
	MOVAR		STK08
	MOVR		_R_Save_Stk09,0
	MOVAR		STK09
	MOVR		_R_Save_Stk10,0
	MOVAR		STK10
	MOVR		_R_Save_Stk11,0
	MOVAR		STK11
__endasm;
#endif

#ifdef	Save_Fsr	 										//恢复中断寻址指针FSR0、FSR1、HBUF
	FSR0 = R_Save_Fsr0;
	FSR1 = R_Save_Fsr1;
	HBUF = R_Save_Hbuf;	
#endif
//---------------------------------------

	__POP();                    	//出栈（恢复A，STATUS）
}

//=============================================================================
//*********************************TC2G初始化***********************************
//TC0设置：8模式，16M，高频系统时钟，1:64分频		t1=(249+1)/(16/64)=1ms
//TC2设置：递增模式，16M，高频系统时钟，1:64分频	t2=(249+1)/(16/64)=1ms
//TC2G设置：TC2门控源TC0溢出周期，门控模式上升沿到上升沿	t=t1+t2=1ms+1ms=2ms
//开启TC2G溢出中断和总中断
//=============================================================================
void TC2G_INIT(void)
{
//1、门控源TC0设置
	T0CR = 0x0E;
	TC0CL = 0;
	TC0CH = 0;
	TC0PRL = 249;
	TC0PRH = 0;
//2、TC2设置
	T2CR = 0x0E;
	TC2CL = 0;
	TC2CH = 0;
	TC2PRL = 249;
	TC2PRH = 0;
//3、3、TC2G门控设置
	T2GCR = 0x82;
	TC0EN = 1;
	TC2EN = 1;
	TC2GO = 1;
//4、中断设置 
	TC2GIF = 0;
	TC2GIE = 1;
	GIE = 1;
}

//=============================================================================
//*********************************系统初始化**********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//=============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init Clock
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	PUB = 0x00;
	PDB = 0x00;
	IOB = 0x00;
	OEB = 0xFF;
	//IOC
	ANSC = 0x00;
	PUC = 0x00;
	PDC = 0x00;
	IOC = 0x00;
	OEC = 0xFF;
	//IOD
	PUD = 0x00;					//注：IOA6、7端口上/下拉控制寄存器必须写0
	PDD = 0x00;
	IOD = 0x00;
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIE = 0;					//1:使能总中断  0:屏蔽总中断
}

//=============================================================================
//********************************RAM清零(00H~FFH)*****************************
//RAM清零：RAM区00H~0FH全部清零
//=============================================================================
void Clr_RAM_00H_FFH(void)   
{
	for(FSR0 = 0;FSR0 != 0xFF;FSR0 ++)
	{
		INDF0 = 0x00;
	}
	if(FSR0 = 0xFF)
	{
		INDF0 = 0x00;
	}
}

//*********************************END OF FILE**********************************