//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
#include "COMMON.H"
//===============================================================================
//***********************************ADC处理*************************************
//===============================================================================
void ADC_Work(void)
{
	volatile u16 R_ADC_Outcome;
	volatile float vddVol;
	//VDD电压采集
	ADCON1 = 0x25;//内部参考2V
	ADC_Delay16us(6);//切换参考电压后建议最少延时100us
	vddVol = GetVDD_Voltage();
	//ADC通道0采集
	ADCON1 = 0x20;//内部参考VDD
	ADC_Delay16us(6);//切换参考电压后建议最少延时100us
	R_ADC_Outcome = ADCDATA_AVERAGE(ADC_CHANNEL_0);
}
//===============================================================================
//**********************************ADC延时函数**********************************
//注意：此程序为在32MHz/4T的情况下延时16*Num (us)
//===============================================================================	
void ADC_Delay16us(unsigned char Num)
{
	volatile unsigned int i, j;
	for(i = 0;i < Num; i++)
	{
		for (j = 0; j < 13; j++);  
	}
}
//===============================================================================
//*********************************ADC通道选择函数*****************************
//ADC通道值转换
//输入		adcChannel						//通道选择参数
//返回通道转换值AD_Data
//===============================================================================
void CHANNEL_SWITCHING(enum ADC_CHANNEL adcChannel)
{
	if ((ADCON0 & 0x1F) != adcChannel)      // 检查当前通道是否不同
    {
        ADCON0 = (unsigned char)((ADCON0 & ~0x1F) | adcChannel);
        ADC_Delay16us(1);                    //切换通道后建议延时,延时时间大于一次转换时间或大于16us
    }
}
//===============================================================================
//**********************************ADC数据采集函数******************************
//ADC通道值转换
//返回采集值AD_Data
//===============================================================================
u16 ADC_CONVERTED(void)
{
	u16 AD_Data;
	ADS = 1;
	while(ADS == 1);
	AD_Data = AD;
	return AD_Data;
}
//===============================================================================
//*******************************ADC失调校准补偿函数*****************************
//ADC失调校准补偿
//返回1表示校准成功
//返回0表示校准失败
//===============================================================================	
u8 ADCSetADVOS(void)
{
	u16 R_GND_Data;
	u8 R_ADVOS_Temp;
	u8 R_ADVOS_Temp_Old;
	u8 R_ADVOS_Cnt = 0x00;
	/* 判断20次查找合适的补偿挡位 */
	for(u8 i = 0;i < 20;i++)
	{
		for(u8 val = 0; val < 16; val++)
		{
			ADCON2 = (unsigned char)((ADCON2 & ~0x0F) | val);  // 保持高位，设置低4位
			CHANNEL_SWITCHING(ADC_CHANNEL_GND);
			R_GND_Data = ADC_CONVERTED();
			if(R_GND_Data > 0x0000)
			{
				if( (ADCON2 & 0x0F) == 0)
				{
					R_ADVOS_Temp = 0;
				}
				else
				{
					R_ADVOS_Temp = (unsigned char)((ADCON2 & 0x0F) - 1);
				}
				break;						//查找到校准挡位
			}
		}
		if(R_ADVOS_Temp_Old == R_ADVOS_Temp)
		{
			R_ADVOS_Cnt++;
			if(R_ADVOS_Cnt > 3)
			{
				ADCON2 &= ~(0x0F << 0);
				ADCON2 |= R_ADVOS_Temp;
				return 1;					//连续四次得到相同结果校准成功
			}
		}
		else
		{
			R_ADVOS_Temp_Old = R_ADVOS_Temp;
			R_ADVOS_Cnt = 0x00;
		}
	}
	return 0;								//校准失败
}
//===============================================================================
//********************************ADC平均函数************************************
//===============================================================================
u16 ADCDATA_AVERAGE(enum ADC_CHANNEL adcChannel)
{
	volatile unsigned	int	 R_ADC_Temp;
	volatile unsigned  	int	 R_ADC_MAX_DATA;
	volatile unsigned  	int	 R_ADC_MIN_DATA;
	volatile unsigned  	int	 R_ADC_Data_Sum;
	uchar i;
	R_ADC_MIN_DATA = 0x0FFF;				 		//最小值赋值
	R_ADC_MAX_DATA = 0x0000;				 		//最大值赋值
	R_ADC_Data_Sum = 0x0000;	
	CHANNEL_SWITCHING(adcChannel);
	for(i = 0;i < 10;i++)
	{
		R_ADC_Temp = ADC_CONVERTED();	
		R_ADC_Data_Sum = R_ADC_Data_Sum + R_ADC_Temp;
		if(R_ADC_Temp > R_ADC_MAX_DATA)
		{
			R_ADC_MAX_DATA = R_ADC_Temp;
		}
		if(R_ADC_Temp < R_ADC_MIN_DATA)
		{
			R_ADC_MIN_DATA = R_ADC_Temp;
		}
	}
	R_ADC_Data_Sum = R_ADC_Data_Sum - R_ADC_MAX_DATA - R_ADC_MIN_DATA;
	R_ADC_Data_Sum = R_ADC_Data_Sum >> 3; 			//剩下8组数据平均	
	return  R_ADC_Data_Sum;
	//测量ADC通道的最后结果放在 R_ADC_Data_Sum			
}
//===============================================================================
//*******************************获取VDD电压函数*********************************
//获取VDD电压（前提是参考电压采用内部参考2V）
//返回求得的电压值R_vdd_Voltage
//===============================================================================	
float GetVDD_Voltage(void)
{
    float R_vdd_Voltage;
    u16 R_ADC_RES;
    R_ADC_RES = ADCDATA_AVERAGE(ADC_CHANNEL_VDD_4);
    R_vdd_Voltage =4 * 2.0 * R_ADC_RES / 4096.0;
    return R_vdd_Voltage;
}
//===============================================================================
//*********************************ADC初始化*************************************
//ADC设置：选择通道为AIN0，数据格式为右对齐，
//时钟源选择为Fcpu/16，内部参考2V
//===============================================================================
void ADC_INIT(void)
{
//1、IO设置
	ANSB0 = 1;
	OEB0 = 0;
//2、ADC设置 
	ADCON0 = 0xA0;
	ADCON1 = 0x45;
	ADCON2 = 0x00;
	ADCON3 = 0x00;	
	ADCON4 = 0x00;
//3、ADC失调校准补偿	
	ADCSetADVOS();

}
/*********************************END OF FILE************************************/