/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* Project Name       : M9F6601_ADC.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version			 : V1.01
* Date				 : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:32M/4T,WDT-Enable-4s,RST-IO,BOR 2.5V 
*说明：本范例AD采集通道为AIN0，时钟源选择为32M/Fcpu，内部参考2V
*采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均,结果存放在R_ADC_DATA_Sum中
*作为一次AD值
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

#include "COMMON.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void ADC_INIT(void);					//ADC初始化
void ADC_Work(void);					//ADC处理程序

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  	//系统初始化
	ADC_INIT();				   	  		//ADC初始化
	while(1) 
	{
		CLRWDT();					  	//清除看门狗
		ADC_Work();
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{		
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{					
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/