/********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例用EPWM0=IOB0,EPWM1=IOB1互补递减模式，产生1khz波形，
前后死区为1个时钟周期，主循环可以动态改变EPWM占空比，实现简易呼吸灯效果。
********************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

//===============================================================================
//********************************EPWM初始化函数*********************************
//===============================================================================
void EPWM_Init(void) 
{
//1. 配置EPWM模块
    // 端口设置
	MPEPWM0 = 0x10;				//EPWM0端口选择为IOB0
	MPEPWM1 = 0x11;				//EPWM1端口选择为IOB1
    // 设置EPWM0和EPWM1为互补模式
    EPWMCON = (1 << 7) |       	// EPWMEN = 1 (使能EPWM模块)
              (0x01 << 3) |   	// EPWMMODE[1:0] = 01 (互补模式)
              (0 << 2) |       	// GROUPEN = 0 (独立模式)
              (0x01);          	// CNTMOD[1:0] = 01 (递减模式)
    
// 2. 配置时钟预分频
    // 系统时钟为32MHz，设置为8分频，得到4MHz EPWM时钟
    EPWM01CKPS = 0x03;  		// 1:8分频
    
// 3. 设置周期和占空比
    // 周期 = 4000 (0x0F9F+1), 占空比 = 1000 (0x03E7+1) (25%占空比)
    EPWMP01H = 0x0F;    		// 周期高字节
    EPWMP01L = 0x9F;    		// 周期低字节
    
    EPWMD0H = 0x03;     		// EPWM0占空比高字节
    EPWMD0L = 0xE7;     		// EPWM0占空比低字节
    
    // 在互补模式下，EPWM1的比较数据寄存器用作死区设置
    // 设置前死区和后死区时间
    EPWMD1H = 0x01;  			// 后死区时间 = 1个时钟周期
    EPWMD1L = 0x01;  			// 前死区时间 = 1个时钟周期
    
// 4. 配置输出极性和输出使能
    EPWMMPINV = 0x00;   		// 所有PWM输出高电平有效
    
    // 使能EPWM0和EPWM1输出
    EPWMOE = (1 << 0) | (1 << 1);
    
// 5. 设置计数模式为自动装载
    EPWMCNTM |= (1 << 0);  		// EPWM01CNTM = 1 (自动装载模式)
    
// 6. 加载配置
    EPWMLOADEN |= (1 << 0);  	// EPWM01LD = 1 (使能加载)
    
// 7. 启动计数器
    EPWMCNTE |= (1 << 0);    	// EPWM01CNTE = 1 (启动计数器)
	
}

/*********************************END OF FILE************************************/