/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_EPWM.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
;* Version			 : V1.01
;* Date				 : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-disEnable-4s,RST-IO,BOR 2.5V 
*说明：本范例用EPWM0=IOB0,EPWM1=IOB1互补递减模式，产生1khz波形，
前后死区为1个时钟周期，主循环可以动态改变EPWM占空比，实现简易呼吸灯效果。
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);						//系统初始化
void EPWM_Init(void);						//EPWM初始化
void delay_ms(u32 ms);						//延时函数
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  			//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	EPWM_Init();				   	  		//EPWM初始化
	while(1) 
	{
		//CLRWDT();					  		//清除看门狗
		//-----------------------------------------------
		// 主循环中可以动态修改PWM参数（实现简易呼吸灯效果）
		//渐亮
        for(u16 i = 0; i < 100; i++) 
		{
			delay_ms(7);
			u16 duty = i * i / 10;  
			if(duty > 1000) 
			{
				duty = 1000;
			}
			EPWMD0H = (duty >> 8) & 0xFF;
			EPWMD0L = duty & 0xFF;
			EPWMLOADEN |= (1 << 0);
			
		}  
		// 渐暗
		for(u16 i = 100; i > 0; i--) 
		{
			delay_ms(7);
			u16 duty = i * i / 10;
			if(duty > 1000)
			{
				duty = 1000;
			}	
			EPWMD0H = (duty >> 8) & 0xFF;	//占空比高位
			EPWMD0L = duty & 0xFF;			//占空比低位
			EPWMLOADEN |= (1 << 0);			//加载周期,占空比数据
			
		}
    }
}
//===============================================================================
//********************************延时函数****************************************
//===============================================================================
void delay_ms(u32 ms) 
{
    // 32M/4T   延时   1.76ms
    for(u32 i = 0; i < ms * 200; i++) 
	{
    
    }
}
//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{					
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{						
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/