#ifndef __COMMON_H__
#define __COMMON_H__

#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

void SYSTEM_INIT(void);					//系统初始化
void EEPROM_INIT(void);					//EE上电查找程序
void EEPROM_Work(void);					//EE处理程序
#define  _DF_FLASH_EE_PageSize 			128//定义一页的个数
//-------------------------------------------------------------------------------
//用户可以自行更改
extern unsigned char Flash_Buff[_DF_FLASH_EE_PageSize]; //Flash缓冲区
unsigned char FLASH_EE_Power_Check(void);				//上电对EE_FLASH的进行查找
void FLASH_EE_Read(unsigned char* ReadDataAddr,unsigned char ReadOffsetAddr,unsigned char ReadNumber);//EE Flash 读 
unsigned char FLASH_EE_WRITE(void);						//EE Flash 写
static void Flash_PageWrite(unsigned int WriteAddr);	//Flash页写 
void Flash_PageErase(unsigned int EraseAddr);			//Flash页擦 
void Flash_Buff_Write(void);							//BUF区数据写入

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
const unsigned int EE_OCCUPY_ADDR @0xF7FE;				//根据配置字的类EE区分配地址将类EE区前两个地址提前占用
const unsigned int Flash_OCCUPY_ADDR @0xFFFE;			//后两个地址提前占用,防止程序分配
const unsigned char EE_Flash_Space[2046] @0xF800;		//类EE区地址提前占用
unsigned char R_Flash_Buff[_DF_FLASH_EE_PageSize]__at(0x0100);//Flash缓冲区
unsigned char R_EE_Test_Data[4];   						//用户数据  本DEMO CODE 用户最多存储127个数据
unsigned char R_EE_Read_Data[4];						//Flash读的数据放在R_EE_Read_Data中

#endif




