/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601 FLASH.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-Enable-64ms,RST-IO,BOR 2.5V，EE区大小2KB（0XF800-0XFFFF）
说明：本范例实现了EE 区上电校验、数据循环更新、双页备份存储、读写验证等完整功能。
程序上电后检查EE区两页备份数据的有效性，若校验通过，恢复上电前存储的数据；
若校验失败，置IOB1 = 1，提示 EE 区数据异常。主循环中每 10ms 执行一次，实现数据的
写入与验证
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  	//系统初始化
	EEPROM_INIT();
	while(1) 
	{
		CLRWDT();					  	//清除看门狗
		EEPROM_Work();
	}
}
//===============================================================================
//*******************************EE_FLASH上电查找********************************
//===============================================================================
void EEPROM_INIT(void)
{
	FLBUFH = ((u16)R_Flash_Buff>> 8) & 0xFF;			//Flash缓冲区设置
	FLBUFL = (u16)R_Flash_Buff & 0xFF;
	if(FLASH_EE_Power_Check())							//上电对EE_FLASH进行查找
	{//数据正确
		//进行上电正确处理;
		FLASH_EE_Read(R_EE_Test_Data,0,4);				//读EE_FLASH的数据
	}
	else
	{//数据错误
		//进行上电错误处理；
		IOB1 = 1;
	}
}

//===============================================================================
//**********************************EEPROM处理***********************************
//EEPROM处理：每10ms累加一次EE_Test_Data然后写入到EE_Flash中，只使用两页，一页用
//作备份，均先擦再写对应的数据，EE_Flash第128个数据是用来校验的，前面127个数据累计
//和再跟0xFF异或得到第128个数据。
//===============================================================================
void EEPROM_Work(void)
{
	u8 i;
	R_EE_Test_Data[0]++;
	if(R_EE_Test_Data[0]==0x00)
	{
		R_EE_Test_Data[1]++;
		if(R_EE_Test_Data[1]==0x00)
		{
			R_EE_Test_Data[2]++;
			if(R_EE_Test_Data[2]==0x00)
			{
				R_EE_Test_Data[3]++;
			}
		}
	}
	Flash_Buff_Write();  								//把R_EE_Test_Data数据送入
	//连续写入10次都失败就说明EE_Flash写入次数用完
	for(i=0;i<10;i++)
	{
		if(FLASH_EE_WRITE())							//FLASH先擦再写
		{
			//写入正确
			//进行正确写入后处理
			break;
		}
	}
	FLASH_EE_Read(R_EE_Read_Data,0,4);					//读EE_FLASH的数据
	for(i=0;i<4;i++)
	{
		if(R_EE_Test_Data[i] != R_EE_Read_Data[i])
		{
			IOB0 = 1;		//与写入数据校验不一致
			break;
		}
		if(i == 3)
		{
			IOB0 = 0;		//与写入数据校验一致
		}
	}
}

//===============================================================================
//********************************BUF区数据写入**********************************
//将数据写入FLASH前，需先将数据写入FLASHBUF区，再对flash进行擦写
//===============================================================================
void Flash_Buff_Write(void)
{
	u8 i;
	R_Flash_Buff[0] = R_EE_Test_Data[0];
	R_Flash_Buff[1] = R_EE_Test_Data[1];
	R_Flash_Buff[2] = R_EE_Test_Data[2];
	R_Flash_Buff[3] = R_EE_Test_Data[3];
	for(i=4;i<127;i++)
	{
		R_Flash_Buff[i]=0x00;		
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/