/***注意：本范例仅供参考，实际应用需评估硬件兼容性
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
u8 I2C_Start();									//起始指令
u8 I2C_SendAddress(u8 addr);	//发送地址
u8 I2C_WriteByte(u8 data);						//发送数据
u8 I2C_Stop();								//结束指令
u8 I2C_Rstart();								//重复起始指令
u8 I2C_ReadByte(u8 ack);						//接收数据

u8 I2C_Master_Write(u8 SlaverAddr , u8 SlaverDataAddr , u8 *pWDataAddr , u8 WriteNumber);				//主机写
u8 I2C_Master_Read(u8 SlaverAddr , u8 SlaverDataAddr , u8 *pRDataAddr , u8 ReadNumber);				//主机读

extern u8 I2C_MASTER_DATA[10];				//定义存放主机向从机写的数据的数组及其地址
extern u8 I2C_MASTER_READ_DATA[10];			//定义存放主机向从机读的数据的数组及其地址
u8 R_I2CDATA;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
#define      I2C_START_SENT    	0X08    //主机发送开始信号完成
#define      STA_M_RSTART    	0X10    //主机发送重新开始信号完成
#define      STA_M_W_ADRACK  	0X18   	//主机发送地址应答
#define      STA_M_W_DATACK   	0X28    //主机发送数据应答
#define      STA_M_R_ADRACK   	0X40    //主机接收地址应答
#define      STA_M_R_DATACK   	0X50    //主机接收数据应答
#define      STA_M_R_DATNACK  	0X58    //主机接收数据不应答

// 超时阈值
#define I2C_TIMEOUT 0XFF

u8 I2C_MASTER_Work(void)					
{	
	//(从机地址,写从机RAM区地址,写数组,写数组长度)
	if(!(I2C_Master_Write(0xA0 , 0x40 , I2C_MASTER_DATA , sizeof(I2C_MASTER_DATA)/sizeof(I2C_MASTER_DATA[0]) ) ) )	 //主机写
	{
		return 0;
	}
	//(从机地址,读从机RAM区地址,读数组,读数组长度)
	if(!(I2C_Master_Read(0xA0 , 0x40 , I2C_MASTER_READ_DATA , sizeof(I2C_MASTER_READ_DATA)/sizeof(I2C_MASTER_READ_DATA[0]))))   //主机读
	{
		return 0;
	}
	for(u8 i=0;i<sizeof(I2C_MASTER_DATA)/sizeof(I2C_MASTER_DATA[0]);i++)//比较写入数据与读出数据是否相等
	{
		if(I2C_MASTER_DATA[i] != I2C_MASTER_READ_DATA[i])
		{
			return 0;
		}				
	}
	return 1;	
}


//===============================================================================
//*********************************I2C主机写*************************************
//主机写：主机向从机发送10个数据，第一个数据为要写入RAM区的地址，其他数据为写入的数据
//===============================================================================	
u8 I2C_Master_Write(u8 SlaverAddr , u8 SlaverDataAddr , u8 *pWDataAddr , u8 WriteNumber) 
{
    if (!I2C_Start()) return 0;			//起始指令
    if (!I2C_SendAddress(SlaverAddr)) 	// 写地址
	{ 		
        I2C_Stop();
        return 0;
    }
	if (!I2C_WriteByte(SlaverDataAddr)) //写入的第一个数据
	{			
        I2C_Stop();
        return 0;
    }				
    for (u8 i = 0; i < WriteNumber; i++) //写入数据
	{
        if (!I2C_WriteByte(*pWDataAddr)) 
		{
            I2C_Stop();
            return 0;
        }
		*pWDataAddr++;
    }
    I2C_Stop();							//写结束指令
    return 1;
}

//===============================================================================
//*********************************I2C主机读*************************************
//主机读：主机先发送要读出RAM区的地址，再读10个数据依次放在数组I2C_MASTER_READ_DATA中
//================================================================================
u8 I2C_Master_Read(u8 SlaverAddr , u8 SlaverDataAddr , u8 *pRDataAddr , u8 ReadNumber)
{
	FSR1 = *pRDataAddr;					//存放地址
    if (!I2C_Start()) return 0;			//起始指令
    if (!I2C_SendAddress(SlaverAddr)) 	//发送从机地址写
	{ 		
        I2C_Stop();
        return 0;
    }
	if (!I2C_WriteByte(SlaverDataAddr)) //发送要读出的RAM区地址
	{			
        I2C_Stop();
        return 0;
    }
	if (!I2C_Rstart()) return 0;		//重复起始指令
	if (!I2C_SendAddress((u8)(SlaverAddr | 0x01))) 		//发送从机地址读
	{ 		
        I2C_Stop();
        return 0;
    }
	
    for (u8 i = 0; i < ReadNumber; i++) //主机读数据
	{		
		if(i==ReadNumber-1){
			if(I2C_ReadByte(0))			//主机读数据不应答
			{
				*pRDataAddr = R_I2CDATA;
			}
			else
			{
				I2C_Stop();
				return 0;
			}
		}
		else
		{
			if(I2C_ReadByte(1))			////主机读数据应答
			{
				*pRDataAddr = R_I2CDATA;
				pRDataAddr++;
			}
			else
			{
				I2C_Stop();
				return 0;
			}
		}
    }
    I2C_Stop();
    return 1;
}

//******************************************************************************
//=================================起始信号=====================================
//******************************************************************************
u8 I2C_Start() 
{
    ST = 1;  // 设置STA位
    u8 timeout = I2C_TIMEOUT;
    while ((I2CSTA  != I2C_START_SENT) && --timeout);	//等待开始状态位产生
	ST = 0;
	if(timeout)
	{
		return 1;
	}else
	{
		return 0;
	}
}

//********************************************************************************
//=================================重复起始信号===================================
//*******************************************************************************
u8 I2C_Rstart() 
{
     ST = 1;  // 设置STA位
	 SI = 0;
    u8 timeout = I2C_TIMEOUT;
    while ((I2CSTA != STA_M_RSTART) && --timeout);		//等待重复起始状态位产生
	ST = 0;
    if(timeout)
	{
		return 1;
	}else
	{
		return 0;
	}
}
//******************************************************************************
//=================================结束信号=====================================
//******************************************************************************
u8 I2C_Stop()
{
    STO = 1;  // 设置STO位
	SI = 0;
	u8 timeout = I2C_TIMEOUT;
    while (STO && --timeout);			// 等待总线释放
	if(timeout)
	{
		STO = 0;
		ST = 0;
		AA = 0;
		SI = 0;
		return 1;
	}
	else
	{
		STO = 0;
		ST = 0;
		AA = 0;
		SI = 0;
		return 0;
	}
}

//******************************************************************************
//============================发送从机地址读、写================================
//******************************************************************************	
// 发送从机地址+模式（返回ACK状态）
u8 I2C_SendAddress(u8 addr)
{
	u8 status;
    I2CDATA = addr;
	SI = 0;
	addr &=0x01;
    u8 timeout = I2C_TIMEOUT;
	if(addr){
		status = STA_M_R_ADRACK;
	}else{
		status = STA_M_W_ADRACK;
	}
    while ((I2CSTA != status) && --timeout) ;		//等待读或者写状态位产生
    if(timeout)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}
//===============================================================================
//*********************************发送数据**************************************
//===============================================================================
u8 I2C_WriteByte(u8 data) 
{
    I2CDATA = data;
	SI = 0;	
    u8 timeout = I2C_TIMEOUT;
    while ((I2CSTA != STA_M_W_DATACK) && --timeout) ;	//等待发送数据状态位产生
    if(timeout)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}
//===============================================================================
//*********************************接收数据**************************************
//===============================================================================
// 接收数据字节（ack=1发送ACK，ack=0发送NACK）
u8 I2C_ReadByte(u8 ack) 
{	
	u8 status;
	if(ack)
	{
		AA = 1;
		status = STA_M_R_DATACK;
	}
	else
	{
		AA = 0;
		status = STA_M_R_DATNACK;
	}
	SI = 0;
    u8 timeout = I2C_TIMEOUT;
    while ((I2CSTA != status) && --timeout) ;			//等待接收数据状态位产生
	if(timeout)
	{
		R_I2CDATA = I2CDATA;
		return 1;
	}
	else
	{
		R_I2CDATA = I2CDATA;
		return 0;
	}
}


//===============================================================================
//**********************************I2C初始化***********************************
//1、端口设置：设置IOB0、IOB1为上拉、数字口，设置端口复用功能IOB0---SCL,IOB1---SDA
//2、I2C设置：作主机
//3、开启总中断
//===============================================================================
void I2C_INIT(void)
{
//1、端口设置
	PUB0 = 1;
	PUB1 = 1;
	ANSB0 = 0;
	ANSB1 = 0;
	MPSCL = 0x10;
	MPSDA = 0x11;
//2、I2C设置
	I2CCR = 0x43;
}

/*********************************END OF FILE************************************/





