/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_I2C_Main.prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
;					 : QQ：411680975
********************************************************************************
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;Option:32M/4T,WDT-Enable-4s,RST-IO,BOR 2.5V 
;说明：本范例是作为I2C主机(SCL:IOB0 SDA:IOB1)
;主机写：主机向从机每次累加发送10个数据I2C_MASTER_DATA，0x40为指定RAM区的地址（用户可更改其他地址）
;主机读：0x40为指定读取从机RAM区的地址（用户可更改其他地址），再读10个数放入数组I2C_MASTER_READ_DATA中
;比较写入的数据与读取的数据是否一致；
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void I2C_INIT(void);					//I2C初始化

u8 I2C_MASTER_Work();				//主机处理程序

u8 I2C_MASTER_DATA[10];				//定义存放主机向从机写的数据的数组及其地址
u8 I2C_MASTER_READ_DATA[10];			//定义存放主机向从机读的数据的数组及其地址
u8	DATA;
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
   	SYSTEM_INIT();                  	//系统初始化
	I2C_INIT();				   			//I2C初始化	
	while(1) 
	{
		u8 i;
		CLRWDT();					  	//清除看门狗
	
		for(i=0;i < 10;i++)				//循环累加写入数组
		{
			I2C_MASTER_DATA[i] = DATA;	//定义主机向从机写的数据的数组
			DATA++;
		}

		if(I2C_MASTER_Work())		//主机IIC处理程序					
		{
			//写入正确
		}
		else						
		{
			//主机读写错误处理	
		}
		
		//用户其他程序	
		
	}
}

//===============================================================================
//******************************中断服务子程序***********************************
//===============================================================================
void interrupt high_priority int_h(void)
{
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{					
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/