/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_IO_Interrupt.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-Disable-4s,RST-IO,BOR 2.5V 
*说明：本范例为若产生IOB0中断，则唤醒休眠，翻转IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
ab8	Flag;
#define	b_IO_Interrupt_Flag	Flag.oneBit.b0
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void IOB_Interrupt_INIT(void);			//IOB中断初始化

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	IOB_Interrupt_INIT();				   	//IOB中断初始化
	while(1) 
	{
		STOP = 1;
		NOP();
		NOP();
		NOP();
		if(b_IO_Interrupt_Flag==1)
		{
			b_IO_Interrupt_Flag = 0;
			IOBOR1 = ~IOBOR1;
		}
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{					
	if(IOBCHIF)
	{
		IOBCHIF = 0;
		b_IO_Interrupt_Flag = 1;
	}
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{						
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//*********************************IOB中断初始化*************************************
//IOB0设置为输入上拉，开启IOB0变化中断
//开启芯片休眠模式
//===============================================================================
void IOB_Interrupt_INIT(void)
{
//1、开启IOB中断
	OEB0 = 0;
	PUB0 = 1;
	IOBICR = 0x01;
	IOBCHIE = 1;	
	IOBCHIF = 0;
	IOBCHIP = 0;			//设置高优先级
	GIEH = 1;
//2、配置OSCM
	OSCM = 0x05;
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/