/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_LED.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-Enable-64ms,RST-IO,BOR 2.5V 
说明：本范例实现 “LED 亮灭模式（8x8 点阵显示数字）” 与 “LED 调光模式（呼吸灯效果）” 
两种可选功能。通过 TC0 定时器提供精准时间基准（125μs~1s），配合中断机制实现 LED 状态自动更新，
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

#define	LED_LM_SW          0	   	// LED亮灭模式（显示数字）
#define	LED_TG_SW          1	   	// LED调光模式（呼吸灯）

#define	T0_125_US          125
#define T_1MS_DF           8       	// 8*125us
#define T_10MS_DF          10      	// 10*1ms
#define T_1S_DF            100     	// 100*10ms
u8  R_LM_DAT;						// LED亮灭模式：显示数字索引（0-7，对应8个数字）
u8	R_TG_DATA;						// LED调光模式：亮度数据（0x00-0xFF）
u8  T_1MS_COUNT = 0;				// 1ms计数
u8  T_10MS_COUNT = 0;				// 10ms计数
u8	R_1s_Count = 0;					// 1s计数
	
ab8 Timer_Flag0;
#define bT_1MS_F             Timer_Flag0.oneBit.b0
#define bT_10MS_F            Timer_Flag0.oneBit.b1
#define B_1S_F            	 Timer_Flag0.oneBit.b2
#define B_Breath_Work_Flag   Timer_Flag0.oneBit.b3	

unsigned char LEDBUF[16] @0xE60;	// LED显示缓冲区（地址0xE60，对应LED共享RAM，参考规格书18.8章节）
// 8x8 LED点阵显示数据（共8组，分别对应数字：0-7）
// 格式：[COM0~COM7][SEG数据]，1表示点亮对应SEG
unsigned char LED_COM_1[8][8]=
                                {{0x00, 0x7c, 0x82, 0x81, 0x81, 0x41, 0x3e, 0x00},  
                                 {0X00, 0X00, 0X01, 0XF1, 0X8F, 0X41, 0X01, 0x00},  
                                 {0X00, 0X60, 0x91, 0x81, 0x89, 0x45, 0x03, 0x00},  
                                 {0X00, 0X64, 0X9A, 0X91, 0X89, 0X41, 0X02, 0x00}, 
                                 {0X00, 0X08, 0XF8, 0X46, 0X28, 0X08, 0X18, 0x00},  
                                 {0X00, 0X8C, 0X92, 0X91, 0X81, 0XD1, 0X36, 0x00},  
                                 {0X00, 0X4C, 0X92, 0X91, 0X81, 0X51, 0X3E, 0x00},
								 {0X00, 0X80, 0XC0, 0XB0, 0X8F, 0X80, 0X00, 0x00}                          
		                        };
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					// 系统初始化
void CLEAN_LED_INIT(void);				// LED显示缓冲区清零
void LED_8X7_DIS(void);					// LED亮灭模式：8x7点阵显示数字
void LED_LM_INIT(void);					// LED亮灭模式初始化（端口、驱动参数配置）
void LED_TG_INIT(void);					// LED调光模式初始化（端口、呼吸灯参数配置）	
void TC0_INIT(void);					// TC0定时器初始化（125μs中断，用于时间基准）
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		
{
	SYSTEM_INIT();                  	// 系统初始化
	TC0_INIT();							// TC0初始化
	CLEAN_LED_INIT();					// LED寄存器清零
#if LED_LM_SW		
	LED_LM_INIT();						// LED亮灭模式初始化
#endif
#if LED_TG_SW
	LED_TG_INIT();						// LED调光模式初始化
#endif
	while(1) 
	{
		CLRWDT();
#if LED_LM_SW							// 若开启LED亮灭模式（显示数字）
		if(B_1S_F)
		{
			B_1S_F=0;
			R_LM_DAT++;
			if(R_LM_DAT>7)
			{R_LM_DAT=0;}
		}
		LED_8X7_DIS();
#endif
#if LED_TG_SW							// 若开启LED调光模式（呼吸灯）
		if(bT_10MS_F)
		{
			if(R_TG_DATA>=0XF8)
			{
				B_Breath_Work_Flag=1;
			}
			if(R_TG_DATA<=0X04)
			{
				B_Breath_Work_Flag=0;
			}
			if(B_Breath_Work_Flag)
			{
				R_TG_DATA-=3;
			}
			else
			{
				R_TG_DATA+=3;
			}
			for(u8 i=8;i<16;i++) 
			{
				LEDBUF[i] = R_TG_DATA;
			}
			bT_10MS_F=0;
		}
#endif
	}
}
//========================================================================
//**************************高优先级中断服务子程序************************
//========================================================================
void interrupt high_priority int_h(void)
{
	if(TC0IF)
	{
		TC0IF = 0;	
		if(++T_1MS_COUNT  >= T_1MS_DF)
		{
			T_1MS_COUNT = 0;
			bT_1MS_F = 1;
		}
		if(bT_1MS_F)
		{
			bT_1MS_F = 0;
			if(++T_10MS_COUNT  >= T_10MS_DF)
			{
				T_10MS_COUNT = 0;
				bT_10MS_F = 1;
				R_1s_Count++;
				if(R_1s_Count >= T_1S_DF)
				{
					R_1s_Count=0;
					B_1S_F =1;
				}
			}
		}
	}	
// -------------------------- LED中断（调光模式，扫描完成触发） --------------------------
#if LED_TG_SW	
	if(LEDIF)
	{	  
		if((LCDCR0&0x07) == 7) 
		{
			LCDCR0 &= 0xF8;
		}
		else
		{
			LCDCR0++;
		}
		LEDIF = 0; 
	}
#endif
}
//========================================================================
//**************************低优先级中断服务子程序************************
//========================================================================
void interrupt low_priority int_l(void)
{				

}
//*************************************************************************
//=============================数字显示====================================
//*************************************************************************
void LED_8X7_DIS(void)
{
	LCDDS00=LED_COM_1[R_LM_DAT][0];	
	LCDDS01=LED_COM_1[R_LM_DAT][1];	
	LCDDS02=LED_COM_1[R_LM_DAT][2];	
	LCDDS03=LED_COM_1[R_LM_DAT][3];	
	LCDDS04=LED_COM_1[R_LM_DAT][4];	
	LCDDS05=LED_COM_1[R_LM_DAT][5];	
	LCDDS06=LED_COM_1[R_LM_DAT][6];	
	LCDDS07=LED_COM_1[R_LM_DAT][7];
}
//*************************************************************************
//=============================LED寄存器清零===============================
//*************************************************************************
void CLEAN_LED_INIT(void)
{
  for(u8 i=0;i<16;i++) 
  {
	LEDBUF[i] = 0;			// 所有SEG初始化为熄灭（0x00）
  }
}

//*************************************************************************
//=============================TC0初始化===================================
// 功能：配置TC0为125μs中断，作为系统时间基准（1ms/10ms/1s均基于此）
// 计数初值：T0_125_US * (32MHz/32预分频) = 125μs
//*************************************************************************
void TC0_INIT(void)
{
//T0
	TC0CH = 0;
	TC0CL = T0_125_US-1;
	T0CR = Bin(10101101);   //32MHz/1:32
	TC0IF = 0;
	TC0IE = 1;
	GIEH = 1;
}
//*************************************************************************
//=============================LED亮灭初始化===============================
/**************************************************************************
* 配置说明：
  - SEG端口：IOD0~IOD7（SEGIOSD=0xFF，配置为SEG功能）
  - LCDCR0：CIOS[2:0]=111（8个COM口）
  - LCDCR1：预分频设置，帧频=Fosch/((LCDPR+1)*256*8*1)（8COM，1组SEG）
  - LCDCR2：LEDEN=1（使能LED），LEDMOD=1（亮灭LED模式），LEDGS=1（8SEG/组），LEDDRIV=0x0E（30mA）
  - LCDCR3：LEDSOUTMOD=0（无效SEG为高阻态），LEDCOUTMOD=0（无效SEG为高阻态），RAM映射方式2
  - LCDCR4：亮灭模式下LEDIF为1时继续扫描
**************************************************************************/
//*************************************************************************
void LED_LM_INIT(void)
{
//1、LED端口设置
	SEGIOSD = 0xFF;
//2、LED设置
	LCDCR0 = Bin(00000111);	
	LCDCR1 = Bin(00001111);			
	LCDCR2 = Bin(11111110);			
	LCDCR3 = Bin(00100000);			
	LCDCR4 = Bin(00010000);	
	IOBODS  = 0XFF;
	IOCODS  = 0XFF;
	IODODS  = 0XFF;
}
//*************************************************************************
//=============================LED调光初始化===============================
/**************************************************************************
* 配置说明：
  - SEG端口：IOC0~IOC7（SEGIOSC=0xFF，配置为SEG功能）
  - LCDCR0：CIOS[2:0]=000（作为IO口）
  - LCDCR1：预分频设置，帧频=Fosch/((LCDPR+1)*256*8*1)（8COM，1组SEG）
  - LCDCR2：LEDEN=1（使能LED），LEDMOD=0（调光LED模式），LEDGS=1（8SEG/组），LEDDRIV=0x0E（30mA）
  - LCDCR3：LEDSOUTMOD=0（无效SEG为高阻态），LEDCOUTMOD=0（无效SEG为高阻态）
  - LCDCR4：-
**************************************************************************/
//*************************************************************************
void LED_TG_INIT(void)
{
//1、LED端口设置
	SEGIOSC = 0xFF;
    LEDIE   =1;
//2、LED设置
	LCDCR0 = Bin(00000000);	
	LCDCR1 = Bin(00001111);			
	LCDCR2 = Bin(11011110);			
	LCDCR3 = Bin(00100000);			
	LCDCR4 = Bin(00010000);	
	IOBODS  = 0XFF;
	IOCODS  = 0XFF;
	IODODS  = 0XFF;
}
//==========================================================================
//**********************************系统初始化******************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//==========================================================================
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00;
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/