/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F6601_SPI_Master.prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/16T,WDT-disable-4s,RST-IO,BOR 2.5V 
*说明：端口SS0(IOB3)、SCK0(IOB2)、SDO0(IOB1)、SDI0(IOB0)
*主机向从机发送txBuffer数组中数据，接收从机发送的数据存放在rxBuffer数组中.
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "COMMON.H"
//=============================================================================
//********************************程序主函数***********************************
//=============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  	//系统初始化
	SPI_Master_Init();					//SPI主机初始化
	
	u8 txBuffer[4] = {0x01, 0x02, 0x03, 0x04}; // 发送缓冲区
    u8 rxBuffer[4] = {0};                      // 接收缓冲区   

	while(1)
	{
		CLRWDT();						//清除看门狗
		
		 // 发送数据并接收从机响应
        if(SPI_Master_Transfer(txBuffer, rxBuffer, 4))
        {
            // 成功接收到数据，可以处理rxBuffer
            
            // 简单示例：将接收到的数据加1后发送回去
            for(u8 i = 0; i < 4; i++)
            {
                txBuffer[i] = (u8)(rxBuffer[i] + 1);
            }
        }
        else
        {
            // SPI通信失败处理
            // 可以添加错误恢复代码
        }
        
        // 适当延时（根据实际需求调整）
        Delay_ms(100);
	}
}


//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{					
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{						
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/