/*
**注意：本范例仅供参考，实际应用需评估硬件兼容性
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "COMMON.H"

// SPI数据传输函数（带超时检测）
u8 SPI_Master_Transfer(u8 *txData, u8 *rxData, u8 len)
{    
    for(u8 i = 0; i < len; i++)
    {
		IOB3 = 0; // 选中从设备
        SPIDATA = txData[i]; // 发送数据
		while(SPIF == 0);	 // 等待传输完成
		
		rxData[i] = SPIDATA;
 
		IOB3 = 1; // 取消选中从设备
    } 
    
    return 1;
}

// 简单延时函数（根据实际时钟调整）
void Delay_ms(u16 ms)
{
    for(u16 i = 0; i < ms; i++)
    {
        for(u16 j = 0; j < 500; j++) // 需要根据实际时钟频率调整
        {
    
        }
    }
}


//=============================================================================
//*******************************SPI主机初始化*********************************
//端口设置：发送口设置为输出模式，接收口设置为输入模式
//SPI主机设置：作为主机，MSB优先，需要片选信号
//=============================================================================
void SPI_Master_Init(void)
{
    // 1. 端口设置	
	MPSPI = 0x10;
    OEB0 = 0;    // SDI0 输入
    OEB1 = 1;    // SDO0 输出
    OEB2 = 1;    // SCK0 输入
	OEB3 = 1;    // SS0 输入
	IOB3 = 1; // 初始时取消选中从机
    ANSB0 = 0; // 所有端口设为数字IO
	ANSB1 = 0;
	ANSB2 = 0;
	ANSB3 = 0;
    // 2. SPI控制器设置
	SPICR = 0xF0;

}





//*********************************END OF FILE***********************************