/**注意：本范例仅供参考，实际应用需评估硬件兼容性
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
// SPI从机模块
// 功能：处理SPI从机通信，包括数据接收和发送
// 特性：
// - 错误处理（模式错误）
// - 中断驱动通信
// - 优化的数据流处理
//===============================================================================

//===============================================================================
// SPI从机工作函数（主循环中调用）
// 功能：处理SPI通信状态和错误
//===============================================================================
void SPI_SLAVER_Work(void)
{
    // 处理模式错误
    if(B_SPI_Slave_State_Flag)
    {
        B_SPI_Slave_State_Flag = 0;
        IOC0 = 1; // 指示错误状态
        
        // 可选：在这里添加错误恢复代码
        // 例如重新初始化SPI接口
    }
    
    // 处理接收完成
    if(B_SPI_RecOK_Flag)
    {
        B_SPI_RecOK_Flag = 0;
   
        // 准备要发送的数据（这里简单回传接收到的数据）
        // 注意：实际发送在中断中完成，这里只是示例
        SPIDATA = spiReceivedData; 
    }
}

//===============================================================================
// SPI从机中断处理函数
// 功能：处理SPI数据传输和错误检测
//===============================================================================
void SPI_S_Interrupt(void)
{
    // 检查是否是SPI中断
    if(SPIIE && SPIF2)
    {
        // 数据传输完成
        if(SPIF)
        {
            spiReceivedData = SPIDATA; // 读取接收到的数据
            B_SPI_RecOK_Flag = 1;  // 设置接收完成标志
        }
		
        // 模式错误检测
        if(MODF)
        {
            B_SPI_Slave_State_Flag = 1;         
            // 可选：在这里添加错误恢复代码
        }
    }
}
//===============================================================================
// SPI从机初始化函数
// 功能：配置SPI从机硬件和中断
//===============================================================================
void SPI_Slave_Init(void)
{
    // 1. 端口设置
	MPSPI = 0x10;
    OEB0 = 0;    // SDI0 输入
    OEB1 = 1;    // SDO0 输出
    OEB2 = 0;    // SCK0 输入
	OEB3 = 0;    // SS0 输入
    ANSB0 = 0; // 所有端口设为数字IO
    ANSB1 = 0;
	ANSB2 = 0;
	ANSB3 = 0;
    // 2. SPI控制器设置
    SPICR = 0xE0; // 从机模式，时钟极性/相位根据主机配置
    // 3. 中断设置
    SPIF2 = 0;   // 清除中断标志
    SPIIE = 1;   // 使能SPI中断
    SPIP = 0;    // 设置中断优先级
    GIEH = 1;    // 使能全局高优先级中断

}
//*********************************END OF FILE**********************************