/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_TC2G.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-Enable-4s,RST-IO,BOR 2.5V 
*说明：本范例是TC2以TC0(1ms定时)门控模式为上升沿到上升沿
*当TC0第二次上升沿TC2G产生中断(2ms)并翻转IOB1口
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void TC2G_INIT(void);					//TC2门控初始化
void TC2G_Interrupt (void);				//TC2门控中断处理函数

//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
ab8	Flag;
#define	b_TC2_Flag	Flag.oneBit.b0

//===============================================================================
//********************************程序主函数*************************************
//主循环每次标志位为高时反转IOB1
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	TC2G_INIT();				   	  		//TC2门控初始化
	while(1) 
	{
		CLRWDT();					  		//清除看门狗
		if(b_TC2_Flag == 1)
		{
			b_TC2_Flag = 0;
			IOBOR1 = ~IOBOR1;
		}
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{
	TC2G_Interrupt();							
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{						
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//*****************************TC2G中断处理函数**********************************
//定时器TC2G每触发一次，进一次中断，b_TC2_Flag 标志位置高
//===============================================================================
void TC2G_Interrupt (void)				
{
	if(TC2GIF)
	{					
		TC2GIF = 0;
		b_TC2_Flag = 1;
		TC2GO = 1;		
	}
}

//===============================================================================
//*********************************TC2G初始化*************************************
//TC0设置：8位模式，32M，高频系统时钟，1:128分频
//TC2门控——TC0溢出周期,用于测试TC0定时脉宽
//开启TC2溢出中断和总中断
//===============================================================================
void TC2G_INIT(void)
{
//1、TC0设置
    T0CR = 0x2F; 			
    TC0CH = 0;				
    TC0CL = 249;				
	TC0EN = 1;
//2、TC2门控设置	
	T2CR = 0X0F;
	TC2GCR = 0x86;
	TC2CL = 0;
	TC2CH = 0;
	TC2PRL = 0XFF;
	TC2PRH = 0XFF;
	TC2EN = 1;
	TC2GO = 1;
//3、高优先级中断设置 
	TC2GIF = 0;				
	TC2GIE = 1;	
	TC2GIP = 0;
	GIEH = 1;				
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/