/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6601_Usart.Prj
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:32M/4T,WDT-Enable-4s,RST-IO,BOR 2.5V 
*说明：本范例为异步串口通讯，串口每100ms发送一个字节数据，串口波特率为38400
*中断接收数据放在R_Receive_Data寄存器中
*串口接收错误数据放在R_Receive_Data_Err寄存器中
*串口端口有复用功能，TX端口为IOB0，RX端口为IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);						//系统初始化
void Usart_INIT(void);						//Usart初始化
void Usart_Send_Byte(unsigned char Data);	//发送一个字节数据	
void Receive_Interrupt (void);				//Usart_Receive中断处理函数
void Delay_100ms(void);						//延时100ms

//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
volatile unsigned char  R_Receive_Data;
volatile unsigned char  R_Receive_Data_Err;
volatile unsigned char 	R_Delay_Count;
volatile unsigned char 	R_Delay_Count_1;

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	Usart_INIT();				   	  		//Usart初始化
	while(1) 
	{
		CLRWDT();					  		//清除看门狗
		Delay_100ms();
		Usart_Send_Byte(0x12);
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//===============================================================================
void interrupt high_priority int_h(void)
{
	Receive_Interrupt();
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//===============================================================================
void interrupt low_priority int_l(void)
{						
	/*
		低优先级中断处理子函数
	*/
}
//===============================================================================
//********************Usart_Receive中断处理函数**********************************
//Usart 接收数据存入R_Receive_Data寄存器中
//串口接收错误数据放在R_Receive_Data_Err寄存器中
//===============================================================================
void Receive_Interrupt (void)				
{
	if(RX0IF)
	{
		if(FR0ER==0)
		{
			R_Receive_Data = RX0REG; 		
		}
		else 
		{
			R_Receive_Data_Err = RX0REG;		
		}
	}
}

//===============================================================================
//**************************延时处理函数*****************************************
//32M/4T延时100ms
//===============================================================================
void Delay_100ms(void)
{
	u8  R_Delay_Cnt = 0;
	for(R_Delay_Cnt = 8;R_Delay_Cnt>0;R_Delay_Cnt--)
	{
		for(R_Delay_Count_1=100;R_Delay_Count_1>0;R_Delay_Count_1--)
		{
			for(R_Delay_Count=250;R_Delay_Count>0;R_Delay_Count--);	
		}
	}
}

//===============================================================================
//***************************Usart_Send处理函数**********************************
//发送一个8位数据
//===============================================================================
void Usart_Send_Byte(unsigned char Data)
{
	TX0REG = Data;
	while(!T0MCLR);
}

//===============================================================================
//*********************************Usart初始化***********************************
//Usart异步发送和接收设置
//开启异步接收中断,波特率为38400
//发送数据为8位，TX复用口为IOB0，RX复用口为IOB1
//===============================================================================
void Usart_INIT(void)
{
//1、设置Usart复用口
//TX0复用口为IOB0
//RX0复用口为IOB1
	MPTX0 = 0x10;
	MPRX0 = 0x11;
	OEB1 = 0;
	PUB1 = 1;
//2、Usart发送设置
	TX0CR = 0x80;
//3、波特率设置
	BRGD0L = 0xCF;
	BRGD0H = 0x00;
//4、Usart接收设置
	RX0CR = 0x80;
//5、中断设置
	RX0IF = 0;
	RX0IE = 1;
	RX0IP = 0;
	GIEH = 1;
	GIEL = 1;				
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	IOAOR = 0x00;			   //IO输出锁存
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00; 
	IOBOR = 0x00;
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;
	IOCOR = 0x00;
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00; 
	IODOR = 0x00;
	OED = 0xFF;
	//IOE
	ANSE = 0x00;  
	PUE = 0x00;               
	PDE = 0x00;				   
	IOE = 0x00; 
	IOEOR = 0x00;
	OEE = 0xFF;
	//IOF
	ANSF = 0x00;  
	PUF = 0x00;               
	PDF = 0x00;				   
	IOF = 0x00;  
	IOFOR = 0x00;
	OEF = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/