/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F680_CMP.Prj
* File Name          : M9F680_CMP.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例比较结果通过IOB1的高低判断
*比较器正相为外部输入IOA5，比较器反相为1/2VDD
*IOB1 = 1  正端输入电压大于负端
*IOB1 = 0  正端输入电压小于负端
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void CMP_INIT(void);					//CMP初始化

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  	//系统初始化
	CMP_INIT();				   	  		//CMP初始化
	while(1) 
	{
		CLRWDT();					  	//清除看门狗
		if(CMPOUT)
		{
			IOB1 = 1;
		}
		else
		{
			IOB1 = 0;
		}
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************空函数***************************************
//空函数做断点保护
//用户不可更改
//===============================================================================
void breakpoint_protect()
{
	
}

//===============================================================================
//*********************************CMP初始化*************************************
//CMP设置：比较器正相为外部输入IOA5，比较器反相为1/2VDD
//===============================================================================
void CMP_INIT(void)
{
//1、IO设置
	OEA5 = 0;
//2、CMP设置 
	CMPC0 = 0xA2;
	CMPC1 = 0x00;
	CMPC2 = 0x00;
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00;                
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;                
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00;               
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/