#ifndef __COMMON_H__
#define __COMMON_H__

#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

#define  _DF_FLASH_EE_PageSize 			64//定义一页的个数
//=================================函数声明===========================================
void Delay_1ms(u16 Delay_Count);//延时
extern unsigned char Flash_Buff[_DF_FLASH_EE_PageSize]; //Flash缓冲区
unsigned char FLASH_EE_Power_Check(void);//上电对EE_FLASH的进行查找
void FLASH_EE_Read(unsigned char* ReadDataAddr,unsigned char ReadOffsetAddr,unsigned char ReadNumber);//EE Flash 读 
unsigned char FLASH_EE_WRITE(void);//EE Flash 写 
static void Flash_PageWrite(unsigned int WriteAddr,unsigned int Flash_Addr_begin,unsigned int Flash_Addr_End);//Flash页写 
static void Flash_PageErase(unsigned int EraseAddr,unsigned int Flash_Addr_begin,unsigned int Flash_Addr_End);//Flash页擦 
static void Flash_EE_Unlock(void);//解锁
static void Flash_EE_lock(void);//上锁
void Flash_Buff_Write(void);//BUF区数据写入

void SYSTEM_INIT(void);					//系统初始化
void Clr_RAM_0000H_01FFH(void);
void EEPROM_INIT(void);					//EE上电查找程序
void EEPROM_Work(void);					//EE处理程序
//===============================================================================
//*******************************FLASH_[2048]************************************
//将FALSH允许擦写区提前全部占用，防止程序分配到此区域
//===============================================================================
const unsigned char EE_Flash_Space[2048] @0x3800;
unsigned char R_Flash_Buff[_DF_FLASH_EE_PageSize]  __at(0x01C0);//Flash缓冲区
unsigned char R_EE_Test_Data[4];    //用户数据  本DEMO CODE 用户最多存储63个数据
unsigned char R_EE_Read_Data[4];	//Flash读的数据放在R_EE_Read_Data中





#endif

