/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F680 FLASH.Prj
* File Name          : Flash_Write_Read.C
* Author             : MASSES CHIP
* Version			 : V2.04
* Date				 : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为FLASH的读写操作.
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//用户可以自行更改
#include "COMMON.H"
//===============================================================================
//**************************FLASH数据校验函数************************************
//通过校验FLASH中存储数据的头码和校验码，对定义的1k空间进行查询找到上电前数据和
//存储位置
//===============================================================================
unsigned char FLASH_EE_Power_Check(void)
{
	u8 i,j;
	u8 R_Page_Count;
	u16 R_Addr_Right;
	u16 R_Addr_Error;
	u16 R_Buf;
	u8 R_CheckSum;
	u8 R_PageNumber;
	u16 R_ReadAddr;	
	u16 R_Flash_EE_Addr_begin;
	u16 R_Flash_EE_Addr_End;
	R_Flash_EE_Addr_begin = (unsigned int)(&EE_Flash_Space[0]);
	R_Flash_EE_Addr_End = R_Flash_EE_Addr_begin+sizeof(EE_Flash_Space);
	R_ReadAddr = R_Flash_EE_Addr_begin;
	R_PageNumber = 0x00;
	for(R_Page_Count=0;R_Page_Count<2;R_Page_Count++)
	{
		R_CheckSum = 0x00;
		//校验写入数据是否正确
		for(j=0;j<_DF_FLASH_EE_PageSize-1;j++)
		{
			R_CheckSum = (unsigned char)(R_CheckSum+ *(const unsigned char *)(R_ReadAddr++));		
		}	
		R_CheckSum = (unsigned char)(R_CheckSum^0xFF);
		if(*(const unsigned char *)(R_ReadAddr++) == R_CheckSum)
		{
			R_PageNumber++;
			R_Addr_Right = (unsigned int)(R_Page_Count<<6)+R_Flash_EE_Addr_begin;
		}
		else
		{
			R_Addr_Error = (unsigned int)(R_Page_Count<<6)+R_Flash_EE_Addr_begin;
		}
	}
	//当读取校验只有一页数据正确就再写入一页同样的数据
	if(R_PageNumber==1)
	{
		//读取正确数据
		for(i=0;i<_DF_FLASH_EE_PageSize;i++)
		{
			R_Buf = *(const unsigned char *)(R_Addr_Right++);
			R_Flash_Buff[i] = R_Buf;	
		}

		//当读取校验只有一页数据正确就再写入一页同样的数据
		Flash_EE_Unlock();//解锁
		Flash_PageErase(R_Addr_Error,R_Flash_EE_Addr_begin,R_Flash_EE_Addr_End);
		Flash_EE_lock();//上锁

		Flash_EE_Unlock();	//解锁
		Flash_PageWrite(R_Addr_Error,R_Flash_EE_Addr_begin,R_Flash_EE_Addr_End);
		Flash_EE_lock();	//上锁
	}
	else if(R_PageNumber==0)//两页数据均错误返回0
	{
		return 0;
	}
	return 1;
}
//===============================================================================
//**************************FLASH_EE_Read函数************************************
//读Flash_EE区间的数据
//输入   ReadDataAddr              //当前读出数据存入的的地址指针
//输入   ReadOffsetAddr            //当前页的偏移地址
//输入   ReadNumber                //当前页读取数量的个数
//返回1说明读取成功
//返回0说明读取失败
//===============================================================================
void FLASH_EE_Read(unsigned char* ReadDataAddr,unsigned char ReadOffsetAddr,unsigned char ReadNumber)
{
	u8 i;
	u8 R_Buf;
	u16 R_ReadAddr;
	R_ReadAddr = (unsigned int)(&EE_Flash_Space[0]);
	R_ReadAddr = R_ReadAddr+ReadOffsetAddr;
	for(i=0;i<_DF_FLASH_EE_PageSize;i++)
	{
		R_Buf = *(const unsigned char *)(R_ReadAddr++);
		if((i>=ReadOffsetAddr)&&(i<ReadNumber))
		{
			ReadDataAddr[i] = R_Buf;
		}
	}
}
//===============================================================================
//**************************FLASH读写次数写入函数********************************
//将FLASH数据读写次数保存，并读出数据进行校验；
//注：读取数据时要注意，要完成写然后擦一轮后读取出来的数据才是当前写入的数据
//返回1说明写入成功
//返回0说明写入失败
//擦除不需要判断返回值
//===============================================================================
unsigned char FLASH_EE_WRITE(void)
{
	u8 i;
	u8 R_Page_Count;
	u16 R_ErasePageAddr;
	u16 R_WritePageAddr;
	u16 R_Flash_EE_Addr_begin;
	u16 R_Flash_EE_Addr_End;
	for(R_Page_Count=0;R_Page_Count<2;R_Page_Count++)
	{
		R_Flash_EE_Addr_begin = (unsigned int)(&EE_Flash_Space[0]);
		R_Flash_EE_Addr_End = R_Flash_EE_Addr_begin+sizeof(EE_Flash_Space);
		R_WritePageAddr = (unsigned int)(R_Page_Count<<6)+R_Flash_EE_Addr_begin;
		R_ErasePageAddr = (unsigned int)(R_Page_Count<<6)+R_Flash_EE_Addr_begin;

		Flash_EE_Unlock();//解锁
		Flash_PageErase(R_ErasePageAddr,R_Flash_EE_Addr_begin,R_Flash_EE_Addr_End);
		Flash_EE_lock();//上锁

		//第64个数据是用来校验的，前面63个数据累计和再跟0xFF异或得到第64个数据
		R_Flash_Buff[_DF_FLASH_EE_PageSize-1] = 0x00;
		for(i=0;i<_DF_FLASH_EE_PageSize-1;i++)
		{
			R_Flash_Buff[_DF_FLASH_EE_PageSize-1] = (unsigned char)(R_Flash_Buff[_DF_FLASH_EE_PageSize-1]+R_Flash_Buff[i]);		
		}
		R_Flash_Buff[_DF_FLASH_EE_PageSize-1] = (unsigned char)(R_Flash_Buff[_DF_FLASH_EE_PageSize-1]^0xFF);
		Flash_EE_Unlock();	//解锁
		Flash_PageWrite(R_WritePageAddr,R_Flash_EE_Addr_begin,R_Flash_EE_Addr_End);//将Flash缓冲区数据写入PageAddr该地址所在页
		Flash_EE_lock();	//上锁
		//校验写入数据是否正确
		for(i=0;i<_DF_FLASH_EE_PageSize;i++)
		{
			if(R_Flash_Buff[i] != *(const unsigned char *)(R_WritePageAddr++))
			{
				return 0;
			}
		}
	}
	return 1;
}
//===============================================================================
//**********************************FLASH解锁函数********************************
//FLASH解锁  
//===============================================================================
static void Flash_EE_Unlock(void)
{
    FLASHLOCK = 0x55;
}
//===============================================================================
//**********************************FLASH上锁函数********************************
//FLASH上锁
//===============================================================================
static void Flash_EE_lock(void)
{
   FLASHLOCK = 0x00;
}
//===============================================================================
//*******************************Flash_PageErase函数*****************************
//Flash擦除当前页数据
//输入   EraseAddr                       //当前要擦除页的首地址
//输入   Flash_Addr_begin                //整个EE_Flash区间的首地址
//输入   Flash_Addr_End                  //整个EE_Flash区间的尾地址
//===============================================================================
static void Flash_PageErase(unsigned int EraseAddr,unsigned int Flash_Addr_begin,unsigned int Flash_Addr_End)
{
	u8 R_Interrupt_Save;  
	R_Interrupt_Save = OPTION;
	GIEL=0;//Flash擦除和写需要关闭总断
	GIEH=0;
	TBLPTR = EraseAddr;
	ERASE = 1;
	#asm;
		MOVR   TBLPTRL
		MOVR   TBLPTRH
	#endasm;
	if(TBLPTR >= Flash_Addr_begin )//检测写FLASH范围
	{
		if(TBLPTR < Flash_Addr_End )//检测写FLASH范围
		{
			if(FLASHLOCK == 0x55 )//检测是否开锁
			{
				EELOCK3 = 1;
				EELOCK2 = 1;
				EELOCK1 = 1;
				#asm;        
				WDT*
				NOP
				#endasm;
			}
		}  
	}		
	OPTION = R_Interrupt_Save;//恢复中断
}
//===============================================================================
//*******************************Flash_PageWrite函数*****************************
//Flash写入，即将R_Flash_Buff数据写入到对应的Flash地址中
//输入   WriteAddr                       //当前要写入页的首地址
//输入   Flash_Addr_begin                //整个EE_Flash区间的首地址
//输入   Flash_Addr_End                  //整个EE_Flash区间的尾地址
//===============================================================================
static void Flash_PageWrite(unsigned int WriteAddr,unsigned int Flash_Addr_begin,unsigned int Flash_Addr_End)
{
	u8 R_Interrupt_Save;
	//unsigned char PageWrite_Status;
	R_Interrupt_Save = OPTION;//保存中断
	GIEL=0; //Flash擦除和写需要关闭总断
	GIEH=0;
	//PageWrite_Status=2;
	TBLPTR = WriteAddr;
	CLRPL = 1;
	WRITE = 1;
	#asm;
		MOVR   TBLPTRL
		MOVR   TBLPTRH
	#endasm;
	if(TBLPTR >= Flash_Addr_begin )//检测写FLASH范围
	{
		if(TBLPTR < Flash_Addr_End )//检测写FLASH范围
		{
			if(FLASHLOCK == 0x55 )//检测是否开锁
			{
				EELOCK3 = 1;
				EELOCK2 = 1;
				EELOCK1 = 1;
				#asm;        
				WDT*
				NOP
				#endasm;
				if(WERR == 0 )
				{
					//PageWrite_Status = 0;
				}
				else
				{
					//PageWrite_Status = 1;
				}	
			}
		}
	}  	
	OPTION = R_Interrupt_Save;
	//return	PageWrite_Status;
}

/*********************************END OF FILE************************************/