/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F680 FLASH.Prj
* File Name          : M9F680_FLASH.C
* Author             : MASSES CHIP
* Version			 : V2.04
* Date				 : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
**注意：本范例仅供参考，实际应用需评估硬件兼容性
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V,3800-3FFF空间允许IAP写入 
*说明：本范例为FLASH的读写操作,上电对EE_FLASH的进行查找,数据错误IOB1置高;
*主循环每10ms累加一次EE_Test_Data然后写入到EE_Flash中，只使用两页，一页用
*作备份，均先擦再写对应的数据，EE_Flash第64个数据是用来校验的，前面63个数据累计
*和再跟0xFF异或得到第64个数据,擦写数据错误IOB0置高.
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//用户可以自行更改
#include "COMMON.H"

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		    //程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	EEPROM_INIT();							//EE_FLASH上电查找
	while(1) 
	{
		CLRWDT();					  		//清除看门狗
		EEPROM_Work();						//EEPROM处理程序
	}
}
//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************空函数***************************************
//空函数做断点保护
//用户不可更改
//===============================================================================
void breakpoint_protect()
{
	
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00;                
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;                
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00;               
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}
//===============================================================================
//************************************延时函数***********************************
//16M/4T下延时1ms程序，时长可通过修改Delay_Count进行修改
//t=Delay_Count*1ms 
//===============================================================================	
void Delay_1ms(u16 Delay_Count)
{
	u16 i;
	u16 Delay_Count1;
	for(i = Delay_Count;i > 0;i--)
	{
		for(Delay_Count1 = 566;Delay_Count1 > 0;Delay_Count1 -- )
		{
		
		}
	}
}	
//===============================================================================
//*******************************EE_FLASH上电查找********************************
//===============================================================================
void EEPROM_INIT(void)
{
	if(FLASH_EE_Power_Check())							//上电对EE_FLASH的进行查找
	{
		IOB1 = 0;
		FLASH_EE_Read(R_EE_Test_Data,0,4);				//读EE_FLASH的数据
	}
	else
	{
		IOB1 = 1;
	}
}
//===============================================================================
//********************************BUF区数据写入**********************************
//将数据写入FLASH前，需先将数据写入FLASHBUF区，再对flash进行擦写
//===============================================================================
void Flash_Buff_Write(void)
{
	u8 i;
	R_Flash_Buff[0] = R_EE_Test_Data[0];
	R_Flash_Buff[1] = R_EE_Test_Data[1];
	R_Flash_Buff[2] = R_EE_Test_Data[2];
	R_Flash_Buff[3] = R_EE_Test_Data[3];
	for(i=4;i<63;i++)
	{
		R_Flash_Buff[i]=0x00;		
	}
}
//===============================================================================
//**********************************EEPROM处理***********************************
//EEPROM处理：每10ms累加一次EE_Test_Data然后写入到EE_Flash中，只使用两页，一页用
//作备份，均先擦再写对应的数据，EE_Flash第64个数据是用来校验的，前面63个数据累计
//和再跟0xFF异或得到第64个数据。
//===============================================================================
void EEPROM_Work(void)
{
	u8 i;
	Delay_1ms(10);
	R_EE_Test_Data[0]++;
	if(R_EE_Test_Data[0]==0x00)
	{
		R_EE_Test_Data[1]++;
		if(R_EE_Test_Data[1]==0x00)
		{
			R_EE_Test_Data[2]++;
			if(R_EE_Test_Data[2]==0x00)
			{
				R_EE_Test_Data[3]++;
			}
		}
	}
	Flash_Buff_Write();  								//把R_EE_Test_Data数据送入
	//连续写入10次都失败就说明EE_Flash写入次数用完
	for(i=0;i<10;i++)
	{
		if(FLASH_EE_WRITE())							//FLASH先擦再写
		{
			//写入正确
			IOB0 = 0;
			break;
		}
	}
	FLASH_EE_Read(R_EE_Read_Data,0,4);					//读EE_FLASH的数据
	for(i=0;i<4;i++)
	{
		if(R_EE_Test_Data[i] != R_EE_Read_Data[i])
		{
			IOB0 = 1;
			break;
		}
		if(i == 3)
		{
			IOB0 = 0;
		}
	}
}

/*********************************END OF FILE************************************/