/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F680_I2C_SLAVER.prj
* File Name          : M9F680_I2C_SLAVER.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
;					 : QQ：411680975
********************************************************************************
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例是作为I2C从机机(SCL:IOB0 SDA:IOB1)
;从机读：从机接收数据放入设定的RAM区中，从机接收的第一个数据为要写入RAM的地址
;其他数据依次写入RAM中
;从机写：主机会先发送一个数据当作要读出RAM区的地址，再依次把RAM区数据写给主机
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
   	SYSTEM_INIT();                  	//系统初始化
	I2C_SLAVER_INIT();					//I2C初始化
	while(1) 
	{
		CLRWDT();					  	//清除看门狗
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm	
	IICSLAVER_Interrupt();               //I2C从机接收中断
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************空函数***************************************
//空函数做断点保护
//用户不可更改
//===============================================================================
void breakpoint_protect()
{
	
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init Clcok
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00;                
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;                
	OEC = 0xFF;
	//IOC
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00;                
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/