/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F680 LED Demo
* File Name          : M9F680_LED.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
******************************************************************************
******************************************************************************
Option: 16M/4T, WDT-Enable-288ms , RS-IO, BOR 2.4V
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明: 本范例驱动LED数码管显示1,2,3
**************************************************************************/
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
/* ab8	Flag;
#define	b_Flag	Flag.oneBit.b0 */
//-------------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);
void Clr_RAM(void);
void LED_INIT(void);

//===============================================================================
//**********************************程序主函数***********************************
//===============================================================================
void main(void)						//程序主函数
{
	SYSTEM_INIT();              	//系统初始化
	LED_INIT();						//LCD初始化
	while(1)
	{
		CLRWDT();					//清除看门狗
	}
}

//===============================================================================
//******************************LED初始化***********************************
//===============================================================================
void LED_INIT(void)
{
//1、IO端口设置
	MPCOM = 0x20;					//IOC设置成LED复用端口
//2、LED端口设置
	COMIOS = 0X0F;					//COM使能选择0,1,2 
	SEGIOSB = 0xFF;					//IOB口用作LED SEG输出
//3、LED设置
	LEDCR0 = 0X4F;					//使能LED，COM使能为“1”，脉冲宽度4ms
	LEDCR1 = 0X1F;					//亮度选择全亮
//4、LED显示数据，共阳极数码管显示1、2、3
	LEDDS08 = 0XF9;
	LEDDS09 = 0XF8;
	LEDDS10 = 0XFA;
	LEDDS11 = 0XF9;
	LEDDS12 = 0XFD;
	LEDDS13 = 0XFF;
	LEDDS14 = 0XF9;
	LEDDS15 = 0XFF; 
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************空函数***************************************
//空函数做断点保护
//用户不可更改
//===============================================================================
void breakpoint_protect()
{
	
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00;                
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;                
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00;               
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}


/*********************************END OF FILE************************************/