/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F680_PWM0.Prj
* File Name          : M9F680_PWM0.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例使用PWM0x输出1KHz占空比为50%的方波
*方波循环开启100ms,关闭100ms
*PWM00复用口为B0
*PWM01复用口为B1
*PWM02复用口为B2
*PWM03复用口为B3
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

//===============================================================================
//******************************定义全局变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
uchar R_Delay_Count;
uchar R_Delay_Count_1;
uchar R_Delay_Count_2;
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void PWM0_INIT(void);					//PWM0初始化
void Delay_100ms(void); 				//延时100ms

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  		//系统初始化
	PWM0_INIT();				   	  		//PWM0初始化
	while(1) 
	{
		CLRWDT();					  		//清除看门狗
		PWM00OE = 1;
		PWM01OE = 1;
		PWM02OE = 1;
		PWM03OE = 1;	
		Delay_100ms();
		PWM00OE = 0;
		PWM01OE = 0;
		PWM02OE = 0;
		PWM03OE = 0;		
		Delay_100ms();	
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//===============================================================================
//**********************************空函数***************************************
//空函数做断点保护
//用户不可更改
//===============================================================================
void breakpoint_protect()
{
	
}

//===============================================================================
//*********************************延时100ms*************************************
//延时100ms
//===============================================================================
void Delay_100ms(void)
{
	for(R_Delay_Count=3;R_Delay_Count>0;R_Delay_Count--)
	{
		for(R_Delay_Count_1=168;R_Delay_Count_1>0;R_Delay_Count_1--)
		{
			for(R_Delay_Count_2=190;R_Delay_Count_2>0;R_Delay_Count_2--);
		}
	}
}

//===============================================================================
//*********************************PWM0初始化*************************************
//TC0设置：8位模式，16M，高频系统时钟，1:64分频
//PWM0配置，独立输出 PWM0x输出1KHz占空比为50%的方波
//===============================================================================
void PWM0_INIT(void)
{
//1、PWM0输出口设置
//PWM00复用口为B0
//PWM01复用口为B1
//PWM02复用口为B2
//PWM03复用口为B3
	MPPWM0 = 0x10;
//2、TC0设置	
	T0CR = 0x2E;
	TC0CL = 249;
	TC0CH = 0;
	TC0EN = 1;
//3、PWM0设置 
	PWM00CR = 0x80;
	PWM01CR = 0x80;
	PWM02CR = 0x80;
	PWM03CR = 0x80;	
	PWM00D = 124;
	PWM01D = 124;
	PWM02D = 124;
	PWM03D = 124;
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void SYSTEM_INIT(void)
{ 
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;  
	PUB = 0x00;                
	PDB = 0x00;				   
	IOB = 0x00;                
	OEB = 0xFF;                
	//IOC
	ANSC = 0x00;  
	PUC = 0x00;               
	PDC = 0x00;				   
	IOC = 0x00;                
	OEC = 0xFF;              
	//IOD
	ANSD = 0x00;  
	PUD = 0x00;               
	PDD = 0x00;				   
	IOD = 0x00;               
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
}

/*********************************END OF FILE************************************/