/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F680_SPI_Master.prj
* File Name          : M9F680_SPI_Master.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*
*Option:16M/4T,WDT-Enable,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*;说明：端口SS0(IOB5)、SCK0(IOB4)、SDO0(IOB3)、SDI0(IOB2)
*向从机发送数据0x55，接收从机发送的数据存放在R_SPI_Receive_Data.
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-----------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);						//系统初始化
void SPI_Master_INIT(void);					//SPI主机初始化
unsigned char SPI_Send_Data(unsigned char R_Data);	//SPI发送数据
void Delay_1ms(void);							//延时
//-----------------------------------------------------------------------------
//定义变量
volatile unsigned char R_SPI_Receive_Data;

//=============================================================================
//********************************程序主函数***********************************
//=============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();                  	//系统初始化
	SPI_Master_INIT();					//SPI主机初始化
	while(1)
	{
		CLRWDT();						//清除看门狗
		R_SPI_Receive_Data = SPI_Send_Data(0x55);			//数据传输
	}
}

//=============================================================================
//********************************SPI发送数据**********************************
//=============================================================================
unsigned char SPI_Send_Data(unsigned char R_Data)
{
	IOB5 = 0;
	SPIDATA = R_Data;
	while(SPIF == 0);
	Delay_1ms();
	IOB5 = 1;
	return(SPIDATA);
}

//=============================================================================
//********************************延时函数*************************************
//=============================================================================
void Delay_1ms(void)
{
	unsigned int i;
	for(i=566;i>0;i--)
	{
	
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		高优先级中断处理子函数
	*/
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//=============================================================================
//**********************************空函数*************************************
//空函数做断点保护
//用户不可更改
//=============================================================================
void breakpoint_protect()
{

}

//=============================================================================
//*******************************SPI主机初始化*********************************
//端口设置：发送口设置为输出模式，接收口设置为输入模式
//SPI主机设置：作为主机，MSB优先，需要片选信号
//=============================================================================
void SPI_Master_INIT(void)
{
//1、端口设置
	OEB5 = 1;			//SS0
	IOB5 = 1;
	OEB4 = 1;			//SCK0
	OEB3 = 1;			//SDO0
	OEB2 = 0;			//SDI0
	ANSB5 = 0;
	ANSB4 = 0;
	ANSB3 = 0;
	ANSB2 = 0;
//2、SPI设置
	SPICR = 0XF0;
}

//=============================================================================
//*********************************系统初始化**********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//=============================================================================	
void SYSTEM_INIT(void)
{
//----------------------------------------------------
//Init Clock
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;
	PUB = 0x00;
	PDB = 0x00;
	IOB = 0x00;
	OEB = 0xFF;
	//IOC
	ANSC = 0x00;
	PUC = 0x00;
	PDC = 0x00;
	IOC = 0x00;
	OEC = 0xFF;
	//IOD
	ANSD = 0x00;
	PUD = 0x00;
	PDD = 0x00;
	IOD = 0x00;
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
}

//*********************************END OF FILE***********************************