/*******************(C) COPYRIGHT 2025 Masses-Chip ****************************
* Project Name       : M9F680_SPI_Slave.prj
* File Name          : M9F680_SPI_Slave.C
* Author             : MASSES CHIP
* Version            : V2.04
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE				 : Luo
*  				 	 : QQ：411680975
*******************************************************************************
*
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*;说明：端口SS0(IOB5)、SCK0(IOB4)、SDO0(IOB3)、SDI0(IOB2)，
*向主机发送数据0xAA，接收主机发送的数据存在R_Receive_Data
******************************************************************************/
//=============================================================================
//*******************************头文件和调用申明******************************
//=============================================================================
//用户不可更改
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
//-----------------------------------------------------------------------------
//用户可以自行更改
void SYSTEM_INIT(void);					//系统初始化
void SPI_Slave_INIT(void);				//SPI从机初始化
void SPI_Interrupt(void);				//SPI中断处理函数
//-----------------------------------------------------------------------------
//定义变量
volatile unsigned char R_Receive_Data;

//=============================================================================
//********************************程序主函数***********************************
//=============================================================================
void main(void)					  		//程序主函数
{
	SYSTEM_INIT();						//系统初始化
	SPI_Slave_INIT();					//SPI从机初始化
	while(1)
	{
		CLRWDT();						//清除看门狗
	}
}

//===============================================================================
//**************************高优先级中断服务子程序*******************************
//高优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt high_priority int_h(void)
{
	#asm
		call  _breakpoint_protect,f
	#endasm
	SPI_Interrupt();					
}

//===============================================================================
//**************************低优先级中断服务子程序*******************************
//低优先级中断入口需调用空函数做断点保护
//注：中断处理调用子函数处理，不要再这里直接处理
//===============================================================================
void interrupt low_priority int_l(void)
{
	#asm
		call  _breakpoint_protect,f			
	#endasm							
	/*
		低优先级中断处理子函数
	*/
}

//=============================================================================
//**********************************空函数*************************************
//空函数做断点保护
//用户不可更改
//=============================================================================
void breakpoint_protect()
{

}

//=============================================================================
//*******************************中断处理函数**********************************
;//接收的数据在RAM区0x20开始存放，返回数据0x55
//=============================================================================
void SPI_Interrupt(void)
{
	if(SPIF2 == 1)
	{
		SPIDATA = 0xAA;
		while(SPIF == 0);
		R_Receive_Data = SPIDATA;
	}
}

//=============================================================================
//*******************************SPI从机初始化**********************************
//端口设置：发送口设置为输出模式，接收口设置为输入模式
//启用SPI通讯，片选信号来自于SSx端口
//开启I2C/SPI中断和总中断
//=============================================================================
void SPI_Slave_INIT(void)
{
//1、端口设置
	OEB5 = 0;				//SS0
	OEB4 = 0;				//SCK0
	OEB3 = 1;				//SDO0
	OEB2 = 0;				//SDI0
	ANSB5 = 0;
	ANSB4 = 0;
	ANSB3 = 0;
	ANSB2 = 0;
//2、SPI设置
	SPICR = 0XE0;
//3、高优先级中断设置
	SPIF2 = 0;
	SPIIE = 1;
	SPIP = 0;
	GIEH = 1;
}

//=============================================================================
//*********************************系统初始化**********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//=============================================================================	
void SYSTEM_INIT(void)
{
//----------------------------------------------------
//Init Clock
	OSCM = 0x00;
//----------------------------------------------------	            
//Init IO
	//IOA
	ANSA = 0x00;               //0:数字口	1:模拟口 
	PUA = 0x00;                //0:上拉关闭 1:上拉使能
	PDA = 0x00;				   //0:下拉关闭 1:下拉使能
	IOA = 0x00;                //IO口数据
	OEA = 0xFF;                //0:输入 1:输出
	//IOB
	ANSB = 0x00;
	PUB = 0x00;
	PDB = 0x00;
	IOB = 0x00;
	OEB = 0xFF;
	//IOC
	ANSC = 0x00;
	PUC = 0x00;
	PDC = 0x00;
	IOC = 0x00;
	OEC = 0xFF;
	//IOD
	ANSD = 0x00;
	PUD = 0x00;
	PDD = 0x00;
	IOD = 0x00;
	OED = 0xFF;
//----------------------------------------------------     
//Init Interrupt
	GIEL = 0;                  //1:全局中断低优先级中断使能,0:屏蔽全局中断低优先级中断
	GIEH = 0;                  //1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
}

//*********************************END OF FILE**********************************