/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : Touch_Lib_CFG.c
* Author             : MASSES CHIP
* Version            : V1.01
* Date               : 2025/12/10
*********************************************************************************



********************************************************************************/
//===================================================================================================
#include "MASSESCHIP_DEFINE.H"
#include "M9F6820_Touch_Lib_CFG.h"

//===================================================================================================
#define TKLib_OPENED_TK_AMOUNT \
(EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5+EnTk6+EnTk7+EnTk8+EnTk9+EnTk10+EnTk11+EnTk12+EnTk13+EnTk14+EnTk15+EnTk16+EnTk17)

#define TKLib_TK_EN_MASK  \
(((u32)EnTk0<<0)|((u32)EnTk1<<1)|((u32)EnTk2<<2)|((u32)EnTk3<<3)\
|((u32)EnTk4<<4)|((u32)EnTk5<<5)|((u32)EnTk6<<6)|((u32)EnTk7<<7)\
|((u32)EnTk8<<8)|((u32)EnTk9<<9)|((u32)EnTk10<<10)|((u32)EnTk11<<11)\
|((u32)EnTk12<<12)|((u32)EnTk13<<13)|((u32)EnTk14<<14)|((u32)EnTk15<<15)\
|((u32)EnTk16<<16)|((u32)EnTk17<<17))

//===================================================================================================
#if EnTk0
#define _DF_TKLib_TK0_F_THRESHOLD   TKLib_TK0_F_THRESHOLD,
#else
#define _DF_TKLib_TK0_F_THRESHOLD  
#endif

#if EnTk1
#define _DF_TKLib_TK1_F_THRESHOLD   TKLib_TK1_F_THRESHOLD,
#else
#define _DF_TKLib_TK1_F_THRESHOLD  
#endif

#if EnTk2
#define _DF_TKLib_TK2_F_THRESHOLD   TKLib_TK2_F_THRESHOLD,
#else
#define _DF_TKLib_TK2_F_THRESHOLD  
#endif

#if EnTk3
#define _DF_TKLib_TK3_F_THRESHOLD   TKLib_TK3_F_THRESHOLD,
#else
#define _DF_TKLib_TK3_F_THRESHOLD  
#endif

#if EnTk4
#define _DF_TKLib_TK4_F_THRESHOLD   TKLib_TK4_F_THRESHOLD,
#else
#define _DF_TKLib_TK4_F_THRESHOLD  
#endif

#if EnTk5
#define _DF_TKLib_TK5_F_THRESHOLD   TKLib_TK5_F_THRESHOLD,
#else
#define _DF_TKLib_TK5_F_THRESHOLD  
#endif

#if EnTk6
#define _DF_TKLib_TK6_F_THRESHOLD   TKLib_TK6_F_THRESHOLD,
#else
#define _DF_TKLib_TK6_F_THRESHOLD  
#endif

#if EnTk7
#define _DF_TKLib_TK7_F_THRESHOLD   TKLib_TK7_F_THRESHOLD,
#else
#define _DF_TKLib_TK7_F_THRESHOLD  
#endif

#if EnTk8
#define _DF_TKLib_TK8_F_THRESHOLD   TKLib_TK8_F_THRESHOLD,
#else
#define _DF_TKLib_TK8_F_THRESHOLD  
#endif

#if EnTk9
#define _DF_TKLib_TK9_F_THRESHOLD   TKLib_TK9_F_THRESHOLD,
#else
#define _DF_TKLib_TK9_F_THRESHOLD  
#endif

#if EnTk10
#define _DF_TKLib_TK10_F_THRESHOLD   TKLib_TK10_F_THRESHOLD,
#else
#define _DF_TKLib_TK10_F_THRESHOLD  
#endif

#if EnTk11
#define _DF_TKLib_TK11_F_THRESHOLD   TKLib_TK11_F_THRESHOLD,
#else
#define _DF_TKLib_TK11_F_THRESHOLD  
#endif

#if EnTk12
#define _DF_TKLib_TK12_F_THRESHOLD   TKLib_TK12_F_THRESHOLD,
#else
#define _DF_TKLib_TK12_F_THRESHOLD  
#endif

#if EnTk13
#define _DF_TKLib_TK13_F_THRESHOLD   TKLib_TK13_F_THRESHOLD,
#else
#define _DF_TKLib_TK13_F_THRESHOLD  
#endif

#if EnTk14
#define _DF_TKLib_TK14_F_THRESHOLD   TKLib_TK14_F_THRESHOLD,
#else
#define _DF_TKLib_TK14_F_THRESHOLD  
#endif

#if EnTk15
#define _DF_TKLib_TK15_F_THRESHOLD   TKLib_TK15_F_THRESHOLD,
#else
#define _DF_TKLib_TK15_F_THRESHOLD  
#endif

#if EnTk16
#define _DF_TKLib_TK16_F_THRESHOLD   TKLib_TK16_F_THRESHOLD,
#else
#define _DF_TKLib_TK16_F_THRESHOLD  
#endif

#if EnTk17
#define _DF_TKLib_TK17_F_THRESHOLD   TKLib_TK17_F_THRESHOLD,
#else
#define _DF_TKLib_TK17_F_THRESHOLD  
#endif

#define TKLib_FINGER_THRESHOLD { \
 _DF_TKLib_TK0_F_THRESHOLD  _DF_TKLib_TK1_F_THRESHOLD  _DF_TKLib_TK2_F_THRESHOLD  _DF_TKLib_TK3_F_THRESHOLD  \
 _DF_TKLib_TK4_F_THRESHOLD  _DF_TKLib_TK5_F_THRESHOLD  _DF_TKLib_TK6_F_THRESHOLD  _DF_TKLib_TK7_F_THRESHOLD  \
 _DF_TKLib_TK8_F_THRESHOLD  _DF_TKLib_TK9_F_THRESHOLD  _DF_TKLib_TK10_F_THRESHOLD _DF_TKLib_TK11_F_THRESHOLD \
 _DF_TKLib_TK12_F_THRESHOLD _DF_TKLib_TK13_F_THRESHOLD _DF_TKLib_TK14_F_THRESHOLD _DF_TKLib_TK15_F_THRESHOLD \
 _DF_TKLib_TK16_F_THRESHOLD _DF_TKLib_TK17_F_THRESHOLD 														 \
}
//===================================================================================================
#if(TKLib_TIM > 4)
#define TKLib_CALIBRATE_TARGET_LINE       1500
#define TKLib_CALIBRATE_TARGET_LINE_MIN   TKLib_CALIBRATE_TARGET_LINE - 1400
#define TKLib_CALIBRATE_TARGET_LINE_MAX   TKLib_CALIBRATE_TARGET_LINE + 1400
#else
#define TKLib_CALIBRATE_TARGET_LINE       1000
#define TKLib_CALIBRATE_TARGET_LINE_MIN   TKLib_CALIBRATE_TARGET_LINE - 800
#define TKLib_CALIBRATE_TARGET_LINE_MAX   TKLib_CALIBRATE_TARGET_LINE + 800
#endif
//===================================================================================================

uc8   CFG_TKCTR0                    = (1<<5)|(0<<4)|(2<<2)|(0<<1)|(1<<0);
uc8   CFG_TKCTR1                    = (0<<6)|(2<<4)|(0<<3)|(TKLib_TIM<<0);
uc8   CFG_TKCTR2                    = (0<<7)|(TKLib_TKCKS<<0);
uc8   CFG_TKCTR3                    = (0<<6)|(0<<4)|(1<<3)|(4<<0);
uc8   CFG_TKCTR4                    = (0<<6)|(1<<4)|(2<<2)|(0<<0);

uc8   CFG_TOUCH_NUM                 = TKLib_TOUCH_NUM;       
uc32  CFG_TK_CH_MASK                = TKLib_TK_EN_MASK;
uc8   CFG_OPENED_TK_AMOUNT          = TKLib_OPENED_TK_AMOUNT;
uc16  CFG_FINGER_THRESHOLD[TKLib_OPENED_TK_AMOUNT]      = TKLib_FINGER_THRESHOLD;

uc16  CFG_CALIBRATE_TARGET_LINE     = TKLib_CALIBRATE_TARGET_LINE;
uc16  CFG_CALIBRATE_TARGET_LINE_MIN = TKLib_CALIBRATE_TARGET_LINE_MIN;
uc16  CFG_CALIBRATE_TARGET_LINE_MAX = TKLib_CALIBRATE_TARGET_LINE_MAX;

uc8   CFG_BASELINE_CALIBRATE_TIME   = TKLib_BASELINE_CALIBRATE_TIME;
uc8   CFG_CONFIRM_TOUCH_TIME        = TKLib_EFFECTIVE_TOUCH_TIME;
uc8   CFG_PowerOn_Delay_Time 		= TKLib_PowerOn_Delay_Time;
uc8   CFG_CONFIRM_NOTOUCH_TIME      = TKLib_INVALID_TOUCH_TIME;
uc16  CFG_CONFIRM_LONGTOUCH_TIME    = TKLib_LONG_TOUCH_TIME;
uc8   CFG_TKRCTR_DATA 				= TKLib_TKRCTR_DATA;
uc8   CFG_TK_ScanCnt 				= TKLib_ScanCnt;

#if TKLib_TouchLowerPower
uc8   CFG_LP_FILTER_LEVEL           = TKLib_TIM;
#if TKLib_LP_FILTER_LEVEL
uc8   CFG_LP_Debounce_TIME          = 3;
#else
uc8   CFG_LP_Debounce_TIME          = 10;
#endif
uc16  CFG_SLEEPTIME                 = TKLib_SlEEP_WAKEUP_TIMER;
uc8   CFG_LP_CHECK_TIMER            = TKLib_LP_CHECK_TIMER;
#endif
//===================================================================================================
u16 BaseLine    	[TKLib_OPENED_TK_AMOUNT]={0};
u16 RawData     	[TKLib_OPENED_TK_AMOUNT]={0};
u16 RawdataRef  	[TKLib_OPENED_TK_AMOUNT]={0};
u8  BaseCnt     	[TKLib_OPENED_TK_AMOUNT]={0};
u8  TouchCnt    	[TKLib_OPENED_TK_AMOUNT]={0};
u8  TKCAL       	[TKLib_OPENED_TK_AMOUNT]={0};
u8  RefAddCnt	  	[TKLib_OPENED_TK_AMOUNT]={0};
u8  RefSubCnt  		[TKLib_OPENED_TK_AMOUNT]={0};
//===================================================================================================
//
//===================================================================================================
#if (TKLib_OPENED_TK_AMOUNT ==0)      
#error "没有通道被检测，请重新设置EnTkn (n=0...17)"
#endif

//***************************************************************************************************
#if EnTk0
#info "TK0:Enable"
#endif
#if EnTk1
#info "TK1:Enable"
#endif
#if EnTk2
#info "TK2:Enable"
#endif 
#if EnTk3
#info "TK3:Enable"
#endif
#if EnTk4
#info "TK4:Enable"
#endif
#if EnTk5
#info "TK5:Enable"
#endif
#if EnTk6
#info "TK6:Enable"
#endif
#if EnTk7
#info "TK7:Enable"
#endif
#if EnTk8
#info "TK8:Enable"
#endif
#if EnTk9
#info "TK9:Enable"
#endif
#if EnTk10
#info "TK10:Enable"
#endif
#if EnTk11
#info "TK11:Enable"
#endif
#if EnTk12
#info "TK12:Enable"
#endif
#if EnTk13
#info "TK13:Enable"
#endif
#if EnTk14
#info "TK14:Enable"
#endif
#if EnTk15
#info "TK15:Enable"
#endif
#if EnTk16
#info "TK16:Enable"
#endif
#if EnTk17
#info "TK17:Enable"
#endif

//***************************************************************************************************
#if TKLib_TouchLowerPower
#info "  触摸低功耗模式：已开启"
#info "  低功耗模式WDT使能选择：绿色或休眠下关闭"
#else
#info "  触摸低功耗模式：未开启"
#endif

//***************************************************************************************************
#if ((TKLib_TK0_F_THRESHOLD <30)||(TKLib_TK0_F_THRESHOLD >255))
#error "TK0通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK1_F_THRESHOLD <30)||(TKLib_TK1_F_THRESHOLD >255))
#error "TK1通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK2_F_THRESHOLD <30)||(TKLib_TK2_F_THRESHOLD >255))
#error "TK2通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK3_F_THRESHOLD <30)||(TKLib_TK3_F_THRESHOLD >255))
#error "TK3通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK4_F_THRESHOLD <30)||(TKLib_TK4_F_THRESHOLD >255))
#error "TK4通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK5_F_THRESHOLD <30)||(TKLib_TK5_F_THRESHOLD >255))
#error "TK5通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK6_F_THRESHOLD <30)||(TKLib_TK6_F_THRESHOLD >255))
#error "TK6通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK7_F_THRESHOLD <30)||(TKLib_TK7_F_THRESHOLD >255))
#error "TK7通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK8_F_THRESHOLD <30)||(TKLib_TK8_F_THRESHOLD >255))
#error "TK8通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK9_F_THRESHOLD <30)||(TKLib_TK9_F_THRESHOLD >255))
#error "TK9通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK10_F_THRESHOLD <30)||(TKLib_TK10_F_THRESHOLD >255))
#error "TK10通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK11_F_THRESHOLD <30)||(TKLib_TK11_F_THRESHOLD >255))
#error "TK11通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK12_F_THRESHOLD <30)||(TKLib_TK12_F_THRESHOLD >255))
#error "TK12通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK13_F_THRESHOLD <30)||(TKLib_TK13_F_THRESHOLD >255))
#error "TK13通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK14_F_THRESHOLD <30)||(TKLib_TK14_F_THRESHOLD >255))
#error "TK14通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK15_F_THRESHOLD <30)||(TKLib_TK15_F_THRESHOLD >255))
#error "TK15通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK16_F_THRESHOLD <30)||(TKLib_TK16_F_THRESHOLD >255))
#error "TK16通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif
#if ((TKLib_TK17_F_THRESHOLD <30)||(TKLib_TK17_F_THRESHOLD >255))
#error "TK17通道的阈值取值，应符合30 <= 设定值 <= 255，请重新设置"
#endif

//***************************************************************************************************
#if (TKLib_TOUCH_NUM == 0)      
#error "TKLib_TOUCH_NUM取值，应符合 1 <= 设定值 <= 开启的通道总数，请重新设置"
#endif

#if (TKLib_TOUCH_NUM > TKLib_OPENED_TK_AMOUNT)      
#error "TKLib_TOUCH_NUM取值，应符合 1 <= 设定值 <= 开启的通道总数，请重新设置"
#endif

//***************************************************************************************************
#if (TKLib_LONG_TOUCH_TIME==0)
#info "TKLib_LONG_TOUCH_TIME取值不建议为0，因为取值为0时，在异常情况下，必需系统重新上电才能恢复"
#endif

#if (TKLib_LONG_TOUCH_TIME > 65535)
#error "TKLib_LONG_TOUCH_TIME最大只能为65535，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_BASELINE_CALIBRATE_TIME < 1)||(TKLib_BASELINE_CALIBRATE_TIME > 14))
#error "触摸按键基线更新速度TKLib_BASELINE_CALIBRATE_TIME取值，应符合1 <= 设定值 <= 14，请重新设置"
#endif

//***************************************************************************************************
#if ((TKLib_TIM < 4)||(TKLib_TIM > 5))
#error "TKLib_TIM取值，应符合4 <= 设定值 <= 5，请重新设置"
#endif

//***************************************************************************************************
#if ((TKLib_TKCKS < 2)||(TKLib_TKCKS > 11))
#error "TKLib_TKCKS取值，应符合2 <= 设定值 <= 11，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_EFFECTIVE_TOUCH_TIME < 1)||(TKLib_EFFECTIVE_TOUCH_TIME > 15))
#error "按键确认次数TKLib_EFFECTIVE_TOUCH_TIME取值，应符合1 <= 设定值 <= 15，请重新设置"
#endif

#if ((TKLib_INVALID_TOUCH_TIME < 1)||(TKLib_INVALID_TOUCH_TIME > 15))
#error "按键取消次数TKLib_INVALID_TOUCH_TIME取值，应符合1 <= 设定值 <= 15，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_TKRCTR_DATA == 0)||(TKLib_TKRCTR_DATA > 255))
#error "TKLib_TKRCTR_DATA取值，应符合1 <= 设定值 <= 255，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_ScanCnt < 1)||(TKLib_TKRCTR_DATA > 30))
#error "TKLib_ScanCnt取值，应符合1 <= 设定值 <= 30，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_PowerOn_Delay_Time < 0)||(TKLib_PowerOn_Delay_Time > 254))
#error "TKLib_PowerOn_Delay_Time取值，应符合0 <= 设定值 <= 254，请重新设置"
#endif
//***************************************************************************************************
/*********************************END OF FILE************************************/
