/******************* (C) COPYRIGHT 2014~2025 MASSES CHIP ************************
* File Name          : MassesChip_Define.h
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
********************************************************************************
 


*******************************************************************************/
#ifndef __COMMON_H__
#define __COMMON_H__

#include "zc.h"
#include "MASSESCHIP_DEFINE.H"

void SYSTEM_INIT(void);					//系统初始化
void ADC_INIT(void);					//ADC初始化
void ADC_Work(void);					//ADC处理程序

/*ADC选择通道*/
enum ADC_CHANNEL//通道0~17
{
    ADC_CHANNEL_0 = 0,
    ADC_CHANNEL_1,
    ADC_CHANNEL_2,
    ADC_CHANNEL_3,
    ADC_CHANNEL_4,
    ADC_CHANNEL_5,
    ADC_CHANNEL_6,
    ADC_CHANNEL_7,
    ADC_CHANNEL_8,
    ADC_CHANNEL_9,
    ADC_CHANNEL_10,
    ADC_CHANNEL_11,
    ADC_CHANNEL_12,
    ADC_CHANNEL_13,
    ADC_CHANNEL_14,
    ADC_CHANNEL_15,
    ADC_CHANNEL_16,
    ADC_CHANNEL_17,
	ADC_CHANNEL_VDD_4,
    ADC_CHANNEL_VREF,
	ADC_CHANNEL_GND,
};
//-------------------------------------------------------------------------------
//用户可以自行更改
u8 ADCSetADVOS(void);//ADC失调校准补偿
u16 ADC_CONVERTED(void);//ADC通道值转换
void ADC_Delay16us(unsigned char Num);//ADC延时函数
u16 ADCDATA_AVERAGE(enum ADC_CHANNEL adcChannel);//采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均函数
float GetVDD_Voltage(void);//获取VDD电压
void SYSTEM_INIT(void);					//系统初始化
void ADC_INIT(void);					//ADC初始化
void ADC_Work(void);					//ADC处理程序
void CHANNEL_SWITCHING(enum ADC_CHANNEL adcChannel);

#endif

/*********************************END OF FILE************************************/
