/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_CMP.Prj
* File Name          : CMP_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例比较结果通过IOB1的高低判断
*比较器正相为外部输入IOA3，比较器反相为1/2VDD
*IOB1 = 1  正端输入电压大于负端
*IOB1 = 0  正端输入电压小于负端
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//***********************************CMP处理*************************************
//CMP处理:得到VDD的电压判断范围以及CP脚和CN脚的大小比较
//===============================================================================
void CMP_Work(void)
{
	GetCmpVDD_Voltage();									//输入VDD电压判断范围
	/*比较器正相为外部输入IOA3，比较器反相为1/2VDD*/
	CMPC0 = 0xE0;
	if(CMPOUT)
	{
		IOB1 = 1;
	}
	else
	{
		IOB1 = 0;
	}
}

//===============================================================================
//*********************************CMP初始化*************************************
//CMP设置：比较器正相为外部输入IOA3，比较器反相为1/2VDD
//===============================================================================
void CMP_INIT(void)
{
//1、IO设置
	OEA3 = 0;
//2、CMP设置 
	CMPC0 = 0xE0;
	CMPC1 = 0x00;
	CMPC2 = 0x00;
}

//===============================================================================
//*******************************VDD电压范围函数*********************************
//获取VDD电压范围,CP口选择VLD,CN口选择1/2VDD
//通过改变CMPC1里VLD的值,得到VDD的电压范围
//===============================================================================
void GetCmpVDD_Voltage(void)
{
	u8 R_CMP_VLD_Temp = 0;
	u8 R_VLD_Temp_Old = 0;
	u8 R_VLD_Cnt = 0;
	volatile float R_vdd_Vldmin = 0.00;
	volatile float R_vdd_Vldmax = 0.00;
	u8 i;	
	/* 判断20次查找对应的挡位 */
	for(i = 0;i < 20;i++)
	{
		for(CMPC1 &= ~(0x1F << 0);(CMPC1 & 0x1F) <= 0x1F;CMPC1++)
		{
		/*CMP比较器输入信号选择位,反相信号输入选择1/2VDD,正相信号输入选择VLD*/
			CMPC0 = 0xE6;
			if(CMPOUT == 1)
			{
				R_CMP_VLD_Temp = (unsigned char)(CMPC1 & 0x1F);
				break;
			}
		}
		if(R_VLD_Temp_Old == R_CMP_VLD_Temp)
		{
			R_VLD_Cnt++;
			if(R_VLD_Cnt > 3)
			{
				R_vdd_Vldmin = (1.25 + 0.05 * (R_CMP_VLD_Temp - 1) ) * 2;
				R_vdd_Vldmax = (1.25 + 0.05  * R_CMP_VLD_Temp) * 2;
			}
		}
		else
		{
			R_VLD_Temp_Old = R_CMP_VLD_Temp;
			R_VLD_Cnt = 0x00;
		}
	}
}

/*********************************END OF FILE************************************/