/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_I2C_SLAVER.prj
* File Name          : M9F6820_I2C_SLAVER_WORK.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
;					 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性 
;说明：本范例是作为I2C从机机(SCL:IOB0 SDA:IOB1)
;从机读：从机接收数据放入设定的RAM区中，从机接收的第一个数据为要写入RAM的地址
;其他数据依次写入RAM中
;从机写：主机会先发送一个数据当作要读出RAM区的地址，再依次把RAM区数据写给主机
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*******************************I2C从机中断处理*********************************
//从机读：从机接收数据放入设定的RAM区中，从机接收的第一个数据为要写入RAM的地址
//其他数据依次写入RAM中
//从机写：主机会先发送一个数据当作要读出RAM区的地址，再依次把RAM区数据写给主机
//===============================================================================
void I2C_Slaver_Handle(void)
{
		switch(I2CSTA)
		{
			case STA_S_R_DATACK:				//从机接收数据应答
			{
				STATE_SRDATACK();
				break;
			}
			case STA_S_R_ADRACK:				//从机接收地址应答
			{
				STATE_SRADRACK();
				break;
			}
			
			case STA_S_R_ADRNACK:				//从机接收地址无应答
			{
				AA = 1;	
				break;
			}
			case STA_S_RSTART:					//从机发送重复开始或停止信号
			{
				AA = 1;
				break;
			}
			case STA_S_W_ADRACK:				//从机发送地址应答
			{
				STATE_SWADRACK();
				break;
			}
			case STA_S_W_DATACK:				//从机发送数据应答
			{
				STATE_SWDATACK();
				break;
			}
			case STA_S_W_DATNACK:				//从机发送数据无应答
			{
				AA = 1;
				break;
			}
			case STA_S_W_LAST:					//从机发送最后数据应答
			{
				AA = 1;
				break;
			}
			default:							//状态错误
			{
				SLAVER_STATE_Err();
				break;
			}
		}
}

//===============================================================================
//*******************************从机接收地址应答********************************
//从机接收地址应答
//===============================================================================
void STATE_SRADRACK(void)
{
	R_Data_Num = 0;
	AA = 1;
	B_I2C_Flag = 1;
}

//===============================================================================
//*******************************从机接收数据应答********************************
//从机接收数据应答
//===============================================================================
void STATE_SRDATACK()
{
	if(B_I2C_Flag == 0)
	{
		I2C_SLAVER_DATA[R_Data_Num] = I2CDATA;
		R_Data_Num++;
		if(R_Data_Num > 15)
		{
			AA = 0;
			R_Data_Num = 0;
		}
		else
		{
			AA = 1;
		}
	}
	else								//主机发送的第一个数据当作要写入RAM的地址
	{
		B_I2C_Flag = 0;						
		FSR1 = I2CDATA;
	}
}

//===============================================================================
//*******************************从机发送地址应答********************************
//从机发送地址应答
//===============================================================================	
void STATE_SWADRACK(void)
{
	I2CDATA = I2C_SLAVER_DATA[R_Data_Num];
	R_Data_Num++;
	AA = 1;
}

//===============================================================================
//*******************************从机发送数据应答********************************
//从机发送数据应答
//===============================================================================	
void STATE_SWDATACK(void)
{
	I2CDATA = I2C_SLAVER_DATA[R_Data_Num];
	R_Data_Num++;
	AA = 1;
}

//===============================================================================
//**********************************状态错误*************************************
//状态错误
//===============================================================================					
void SLAVER_STATE_Err(void)
{
	I2CCR &= 0xBB;
	I2CCR |= 0x44;
}

//===============================================================================
//*******************************IIC从机中断处理函数*****************************
//IIC从机中断处理函数
//===============================================================================
void IICSLAVER_Interrupt (void)
{
	if(I2CIE == 1)							//防止主机程序进入中断
	{
		if(SI == 1)
		{
			I2C_Slaver_Handle();			//I2C从机处理程序
			SI = 0;
		}
	}
}
/*===============================================================================
**********************************I2C初始化***********************************
1、端口设置：设置IOB0、IOB1为上拉、数字口，设置端口复用功能IOB0---SCL,IOB1---SDA
2、I2C设置：作从机，从机地址0xA0
3、开中断
4、在RAM区写数据：在RAM区(0x0020-0x002F)写入0x0F-0x00
===============================================================================*/	
void I2C_SLAVER_INIT(void)
{
//1、端口设置
	PUB0 = 1;
	PUB1 = 1;
	ANSB0 = 0;
	ANSB1 = 0;
	MPSCL = 0x10;
	MPSDA = 0x11;
//2、I2C设置
	I2CCR = 0x44;	
	I2CADR = 0xA0;
//3、开高优先级中断
	I2CIE = 1;
	I2CIP = 0;
	GIEH = 1;
}
/*********************************END OF FILE************************************/