/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_IO_Interrupt.Prj
* File Name          : IO_Interrupt_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
* Web    			 : www.masses-chip.com
* FAE                : Luo
*  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为若产生IOB0中断，则唤醒休眠，翻转IOB1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//*********************************端口变化中断主函数****************************
//IO变化中断产生时翻转IOB1口
//进休眠
//===============================================================================
void IO_Interrupt_Work(void)					  		//程序主函数
{
	if(b_IO_Interrupt_Flag == 1)
	{
		b_IO_Interrupt_Flag = 0;
		if(IOB1 == 1)
		{
			IOB1 = 0;
		}
		else
		{
			IOB1 = 1;	
		}
	}
	STOP = 1;
	NOP();
	NOP();
	NOP();
}

//===============================================================================
//**********************************端口中断处理函数*****************************
//IO变化中断，进一次中断，标志位置高
//===============================================================================
void IO_Interrupt(void)
{
	if(IOBCHIF)
	{
		IOBCHIF = 0;
		b_IO_Interrupt_Flag = 1;
	}
}

//===============================================================================
//*********************************IOB中断初始化*************************************
//IOB0设置为输入上拉，开启IOB0变化中断
//开启芯片休眠模式
//===============================================================================
void IOB_Interrupt_INIT(void)
{
//1、开启IOB中断
	OEB0 = 0;
	PUB0 = 1;
	IOBICR = 0x01;
	IOBCHIE = 1;	
	IOBCHIF = 0;
	IOBCHIP = 0;			//设置高优先级
	GIEH = 1;
//2、进休眠
	OSCM = 0x05;
}

/*********************************END OF FILE************************************/