/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M9F6820_PWM0.Prj
* File Name          : PWM0_Work.C
* Author             : MASSES CHIP
* Version            : V1.03
* Date               : 2025/08/15
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例使用PWM0x输出1KHz占空比为50%的方波
*方波循环开启100ms,关闭100ms
*PWM00复用口为B0
*PWM01复用口为B1
*PWM02复用口为B2
*PWM03复用口为B3
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "COMMON.H"
//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void PWM0_Work(void)
{
	PWM00OE = 1;
	PWM01OE = 1;
	PWM02OE = 1;
	PWM03OE = 1;	
	Delay_100ms();
	PWM00OE = 0;
	PWM01OE = 0;
	PWM02OE = 0;
	PWM03OE = 0;		
	Delay_100ms();
}

//===============================================================================
//*********************************延时100ms*************************************
//延时100ms/4T下
//===============================================================================
void Delay_100ms(void)
{
	u8	R_Delay_Count,R_Delay_Count_1,R_Delay_Count_2;
	for(R_Delay_Count = 3;R_Delay_Count > 0;R_Delay_Count --)
	{
		for(R_Delay_Count_1 = 172;R_Delay_Count_1 > 0;R_Delay_Count_1 --)
		{
			for(R_Delay_Count_2 = 190;R_Delay_Count_2 > 0;R_Delay_Count_2 --);
		}
	}
}
//===============================================================================
//*********************************PWM0初始化*************************************
//TC0设置：8位模式，16M，高频系统时钟，1:64分频
//PWM0配置，独立输出 PWM0x输出1KHz占空比为50%的方波
//===============================================================================
void PWM0_INIT(void)
{
//1、PWM0输出口设置
//PWM00复用口为B0
//PWM01复用口为B1
//PWM02复用口为B2
//PWM03复用口为B3
	MPPWM0 = 0x10;
//2、TC0设置	
	T0CR = 0x2E;
	TC0CL = 249;
	TC0CH = 0;
	TC0EN = 1;
//3、PWM0设置 
	PWM00CR = 0x80;
	PWM01CR = 0x80;
	PWM02CR = 0x80;
	PWM03CR = 0x80;	
	PWM00D = 124;
	PWM01D = 124;
	PWM02D = 124;
	PWM03D = 124;
}
/*********************************END OF FILE************************************/